
;; test support: set the following to file-name (without .pvs), theory-name
;; to test that theory
;; then add option -f latex-test

(setq test-theory '("state-transformer" "Transformer_Invariant_3"))

(setq test-latex-mode nil)

(setq verbose-latex-output nil)

(setq with-subsections-in-toc t)

(setq proof-file-stem "proof-")

(setq root-file "everything")

(setq file-counter 0)

(setq include-all-name "all-proofs-include.tex")


(defun latex-test ()
  (setq test-latex-mode t)
  (setq proof-file-stem "test-proof-")
  (setq root-file (car test-theory))
  (setq include-all-name "xx.tex"))


(setq include-all-start "\
% Automatically generated by latex-all-proofs

")


(setq include-all-end "\n")


;; test if ppe works on all the theories in the context
(defun test-ppe ()
  (let (all-theories th ppe-name ppe-buf)
    (setq all-theories
	  (sort (pvs-collect-theories)
		'(lambda (a b) (string< (car a) (car b)))))
    (while all-theories
      (setq th (caar all-theories))
      (setq all-theories (cdr all-theories))
      (setq ppe-name (format "%s.ppe" th))
      (message "TRY ppe on %s" th)
      (prettyprint-expanded th)
      (setq ppe-buf (get-buffer ppe-name))
      (set-buffer ppe-buf)
      (message "ppe %s in %s" th ppe-buf))))




(defun theorems-of-theory (thname)
  (let ((lemmas))
    (let ((pvs-verbose 0))
      (status-proof-theory thname))
    (save-excursion
      ;;(message "select status in theorems search")
      (set-buffer "PVS Status")
      ;;(message "Status buffer\n%s\n\n" (buffer-string))
      (goto-char (point-min))
      (search-forward "Proof summary for theory")
      (forward-line 1)
      (while (not (looking-at " *Theory totals:"))
	(if (looking-at " *\\([A-Za-z0-9?_]*\\)\\.")
	    (setq lemmas (cons (match-string 1) lemmas))
	  (error "Unexpected line %d in PVS Status" (current-line-number)))
	(forward-line 1)))
    (reverse lemmas)))

(setq obligation-regexp
      (concat
       "\\([Ll][Ee][Mm][Mm][Aa]\\|"
       "[Tt][Hh][Ee][Oo][Rr][Ee][Mm]\\|"
       "[Oo][Bb][Ll][Ii][Gg][Aa][Tt][Ii][Oo][Nn]"
       "\\)"))


(defun insert-with-underscore (&rest text)
  "inserts text in the current buffer like insert, but escapes
   underscores in it"
  (let (replace-start replace-end)
    (setq replace-start (point))
    (while text
      (insert (car text))
      (setq text (cdr text)))
    (setq replace-end (point-marker))
    (goto-char replace-start)
    (while (search-forward "_" replace-end t)
      (replace-match "\\\\_"))
    (set-marker replace-end nil)
    (goto-char (point-max))))


;; no-ppe: search lemmas in file (which has to be narrowed to the
;; theory) and tcc buffer.
(defun do-lemma-no-ppe (current-lemma theory-buffer theory-start-line-number
			       file-name tcc-buffer current-theory all-buf)
  (let (lemma-regexp lemma-line proof-gen-file-name
	lemma-buffer lemma-buffer-ext)
    (message "\n==  Lemma %s" current-lemma)
    (set-buffer theory-buffer)
    (goto-char (point-min))
    (setq lemma-regexp
	  (format "^[^%%]*\\<%s *: *%s"
		  (regexp-quote current-lemma) obligation-regexp))
    (if (search-forward-regexp lemma-regexp nil t)
	(progn
	  (setq lemma-line (+ theory-start-line-number
			      (count-lines (point-min) (point))))
	  (setq lemma-buffer file-name)
	  ;;(message "set pvs lemma-buffer to %s" lemma-buffer)
	  (setq lemma-buffer-ext "pvs"))
      ;; not found, search the tcc buffer
      (if (and tcc-buffer
	       (set-buffer tcc-buffer)
	       (search-forward-regexp lemma-regexp nil t))
	  (progn
	    (setq lemma-line (+ 1 (count-lines (point-min) (point))))
	    (setq lemma-buffer current-theory)
	    ;;(message "set tcc lemma-buffer to %s" lemma-buffer)
	    (setq lemma-buffer-ext "tccs"))
	(error "Cannot find lemma %s")))

    (let ((send-string
					;(prove-file-at "Number_Props" nil 10 t "tccs" "Number_Props.tccs" 0 t nil nil)
					;(prove-file-at "vfiasco-prelude" nil 71 t "pvs" "vfiasco-prelude.pvs" 0 t nil nil)
	   (format
	    "(prove-file-at \"%s\" nil %d t \"%s\" \"%s.%s\" 0 t nil nil)"
	    lemma-buffer lemma-line lemma-buffer-ext
	    lemma-buffer lemma-buffer-ext)))
      (message "ilisp-send %s" send-string)
      (ilisp-send send-string nil 'pr nil))

    (setq proof-gen-file-name
	  (format "%s%04d" proof-file-stem file-counter))
    (setq file-counter (+ file-counter 1))

    (let ((current-prefix-arg (not verbose-latex-output)))
      (latex-proof proof-gen-file-name))

    (set-buffer all-buf)
    (if with-subsections-in-toc
	(insert-with-underscore
	 "\\mysubsection{" current-lemma "}{"
	 current-theory "." current-lemma "}")
      (insert-with-underscore
	 "\\subsection*{" current-theory "." current-lemma "}"))
	
    (insert
     "\\label{" current-theory "-" current-lemma "}"
     "\\input{" proof-gen-file-name "}"
     "\n")))


;; no-ppe: search lemmas in file (which has to be narrowed to the
;; theory) and tcc buffer.
(defun do-theory-no-ppe (current-theory file-name all-buf)
  (let (theory-buffer theory-start theory-start-line-number
	tcc-buffer-name tcc-buffer lemmas)
    (message "\n=================================\n======= Theory %s\n"
	     current-theory)

    (set-buffer all-buf)
    (insert-with-underscore 
     "\n\n\\mysection{Proofs for " current-theory " (" file-name ".pvs)}\n")

    (setq lemmas (theorems-of-theory current-theory))
    (if (not lemmas)
	(progn
	  (set-buffer all-buf)
	  (insert "This theory contains no provable formal statements.\n"))

      ;; else: do the following only if there are some lemmas
      (setq theory-buffer (find-theory current-theory))
      (if (not (eq (current-buffer) theory-buffer))
	  (error "Not in buffer %s as expected" theory-buffer))
      (setq theory-start (point))
      (setq theory-start-line-number
	    (+ 1 (count-lines (point-min) theory-start)))
      (if (not (search-forward-regexp
		(format "[Ee][Nn][Dd] *%s" current-theory)))
	  (error "Cannot find theory end"))
      (narrow-to-region theory-start (point))

      (setq tcc-buffer-name (format "%s.tccs" current-theory))
      (let ((pvs-verbose 0))
	(show-tccs current-theory))
      (setq tcc-buffer (get-buffer tcc-buffer-name))
      (if (not tcc-buffer)
	  (message "No TCC buffer for %s" current-theory))

      (while lemmas
	(do-lemma-no-ppe (car lemmas) theory-buffer
			 theory-start-line-number file-name tcc-buffer
			 current-theory all-buf)
	(setq lemmas (cdr lemmas))))

    (if tcc-buffer
	(kill-buffer tcc-buffer))
    (if theory-buffer
	(progn
	  (set-buffer theory-buffer)
	  (widen)))

    (set-buffer all-buf)
    (save-buffer)))



;; ppe version: search lemmas and TCCS in the ppe buffer
(defun do-lemma-ppe (current-lemma ppe-buffer file-name current-theory all-buf)
  (let (lemma-regexp lemma-line proof-gen-file-name
	lemma-buffer-name lemma-buffer-ext)
    (message "\n==  Lemma %s" current-lemma)
    (set-buffer ppe-buffer)
    ;(message "first ppe-buffer")
    (goto-char (point-min))
    (setq lemma-regexp
	  (format "^[^%%]*\\<%s *: *%s"
		  (regexp-quote current-lemma) obligation-regexp))
    (if (search-forward-regexp lemma-regexp nil t)
	(progn
	  (setq lemma-line (count-lines (point-min) (point)))
	  (setq lemma-buffer-name current-theory)
	  ;;(message "set pvs lemma-buffer-name to %s" lemma-buffer-name)
	  (setq lemma-buffer-ext "ppe"))
      (error "Cannot find lemma %s"))

    (let ((send-string
;(prove-file-at "Number_Props" nil 10 t "tccs" "Number_Props.tccs" 0 t nil nil)
;(prove-file-at "vfiasco-prelude" nil 71 t "pvs" "vfiasco-prelude.pvs" 0 t nil nil)
	   (format
	    "(prove-file-at \"%s\" nil %d t \"%s\" \"%s.%s\" 0 t nil nil)"
	    lemma-buffer-name lemma-line lemma-buffer-ext
	    lemma-buffer-name lemma-buffer-ext)))
      (message "ilisp-send %s" send-string)
      (ilisp-send send-string nil 'pr nil))

    (setq proof-gen-file-name
	  (format "%s%04d" proof-file-stem file-counter))
    (setq file-counter (+ file-counter 1))

    (let ((current-prefix-arg (not verbose-latex-output)))
      (latex-proof proof-gen-file-name))

    (set-buffer all-buf)
    ;(message "do-lemma all-buf")
    (if with-subsections-in-toc
	(insert-with-underscore
	 "\\mysubsection{" current-lemma "}{"
	 current-theory "." current-lemma "}")
      (insert-with-underscore
	 "\\subsection*{" current-theory "." current-lemma "}"))
	
    (insert
     "\\label{" current-theory "-" current-lemma "}"
     "\\input{" proof-gen-file-name "}"
     "\n")))


;; ppe version: search lemmas and TCCS in the ppe buffer
(defun do-theory-ppe (current-theory file-name all-buf)
  (let (lemmas ppe-name ppe-buffer)
    (message "\n=================================\n======= Theory %s\n"
	     current-theory)

    (set-buffer all-buf)
    ;(message "first all-buf")
    (insert-with-underscore 
     "\n\n\\mysection{Proofs for " current-theory " (" file-name ".pvs)}\n")

    (setq lemmas (theorems-of-theory current-theory))
    (if (not lemmas)
	(progn
	  (set-buffer all-buf)
	  ;(message "second all-buf")
	  (insert "This theory contains no provable formal statements.\n"))

      ;; else: do the following only if there are some lemmas
      (setq ppe-name (format "%s.ppe" current-theory))
      (let ((pvs-verbose 0))
	(prettyprint-expanded current-theory))
      (setq ppe-buffer (get-buffer ppe-name))
      (if (not ppe-buffer)
	  (error "prettyprint-expanded apparently failed on theory %s"
		 current-theory))

      (while lemmas
	(do-lemma-ppe (car lemmas) ppe-buffer file-name current-theory all-buf)
	(setq lemmas (cdr lemmas))))

    (if ppe-buffer
	(kill-buffer ppe-buffer))
    (set-buffer all-buf)
    ;(message "third all-buf")
    (save-buffer)))


(defun latex-all-proofs ()
  (let (all-theories include-all-buf)
    (typecheck root-file)

    (setq all-theories
	  (sort (pvs-collect-theories)
		'(lambda (a b) (string< (car a) (car b)))))

    (setq include-all-buf (find-file-noselect include-all-name))
    (set-buffer include-all-buf)
    (erase-buffer)
    (insert include-all-start)

    (if test-latex-mode
	(do-theory-ppe (cadr test-theory) (car test-theory) include-all-buf)

      ;; no test - run everything
      (while all-theories
	(do-theory-ppe (caar all-theories) (cadar all-theories) include-all-buf)
	(setq all-theories (cdr all-theories))))

    (message "\nAll theories finished.")
    (set-buffer include-all-buf)
    (insert include-all-end)
    (save-buffer)))


      
  
