#!/usr/bin/perl

$inside_status=0;

print "Startup / Typechecking\n";

$newline=0;
$unprovable=0;
$interrupted=0;
$count_ok=0;
$count_unprovable=0;
$count_failed=0;
$count_noproof=0;
$count_timeout=0;
$pvs_count_total=-1;
$pvs_count_ok=-1;
$grand_totals_line="";
$counter=1;
$proof_count=undef;
$|=1;				# do autoflush on STDOUT

open(TS, ">Validate/timed-status");


sub find_proof_count {
    while(<>) {
	/^Grand Totals: ([0-9]+) proofs, ([0-9]+) attempted, ([0-9]+) succeed/
	    && do {
		$proof_count=$1;
		next;
	    };

	/^=====> end initial status-proof-importchain <=====$/ && do {
	    $inside_status=0;
	    defined($proof_count) || die "missed total line in initial status";
	    return;
	};
    }
}

sub do_status {
    while(<>) {
	/^$/ && next;
	/^ Proof summary for theory (.*)$/ && do {
	    do_theory($_, $1);
	    next;
	};

	/^=====> end status-proof-importchain <=====$/ && do {
	    $inside_status=0;
	    return;
	};

	/^Grand Totals: ([0-9]+) proofs, ([0-9]+) attempted, ([0-9]+) succeed/
	    && do {
		$pvs_count_total=$1;
		$pvs_count_ok=$3;
		$grand_totals_line=$_;
		next;
	    };

	print STDERR "status parse error in the following line\n", $_, "\n";
    }
}

sub do_theory($$) {
    my($line, $name) = @_;
    my $theory = $line;
    while(<>) {
	/^$/ && do {
	    $theories{$name} = $theory;
	    return;
	};
	$theory .= $_;
    }
}


while(<>){
    #chomp;
    #print "+ ", $_, "+\n";

    if( /^=====> initial status-proof-importchain <=====$/ ) {
	$inside_status=1;
	print "initial status...";
	find_proof_count();
	print " finished\n\n";
    }

    if( /^=====> status-proof-importchain <=====$/ ) {
	$inside_status=1;
	do_status();
	print TS "\n\n";
	foreach $th ( sort keys %theories ) {
	    print TS $theories{$th}, "\n\n";
	}
	print TS $grand_totals_line, "\n";
	next;
    }

    # if($copy){
    # 	while( $_ ne "" ){
    # 	    s/^Garbage collecting...done//  && next;
    # 	    s/^Garbage collecting...//  && next;
    # 	    s/^PVS is garbage collecting...// && next;
    # 	    s/^Finished garbage collecting// && next;
    # 	    last;
    # 	};
    # 	print $_;
    # 	next;
    # }
    
    if(
       /^Typechecking / ||
       /^Restored theory from /
       ){
	print "  ", $_;
	$newline=0;
    }
    if(/^Rerunning proof of /){
	$interrupted == 0 or die "interrupt flag not reset";
	chomp;
	if($newline) {
	    print "\n";
	}
	$line = "[$counter/$proof_count] prove " . substr($_, 19);
	print "  ", $line;
	$newline=1;
	if(/unprovable/){
	    $unprovable=1;
	} else {
	    $unprovable=0;
	}
	$proof_line=$line;
    }

    if(/^[^ ]+ proved in /){
	#print " [1;32mok[m\n", " (", $_, ")";
	print " [1;32mok[m\n";
	$newline=0;
	$count_ok++;
	$counter++;
    }

    if(/^[^ ]+ unproved in /){
	if($interrupted){
	    print "[0G";
	    print "  [1;35m", $proof_line, " timeout[m\n";
	    print TS "timeout ", $proof_line, "\n";
	    $interrupted=0;
	    $count_timeout++;
	}
	elsif($unprovable){
	    print " [31mfail (as expected)[m\n";
	    $count_unprovable++;
	} else {
	    print "[0G";
	    print "  [1;31m", $proof_line, " failed[m\n";
	    $count_failed++;
	}
	$newline=0;
	$counter++;
    }

    if(/has no proof/){
	if($newline) {
	    print "\n";
	}
	print "  [1;31m[$counter/$proof_count] ", $_, "[m";
	$newline=0;
	$count_noproof++;
	$counter++;
    }	
	

    if(/Interrupted:.*timeout/){
	$interrupted=1;
    }

    /=====> prove-importchain / && do { print $_;};

}

if($newline) {
    print "\n";
}

if($inside_status) {
    print STDERR "missed end of status-prove-importchain line\n";
}

if($pvs_count_total == -1 ) {
    print STDERR "missed Grand Totals line\n";
}

if($pvs_count_total != 
   $count_unprovable + $count_ok + $count_failed + 
   $count_noproof + $count_timeout) {
    print STDERR "\nPROOF COUNT CHECK FAILED!\n\n";
    $pvs_count_total = 
	$count_unprovable + $count_ok + $count_failed + 
	$count_noproof + $count_timeout;
}

$summary = 
    "Summary: $pvs_count_total proofs, " .
    "$count_timeout timeout, " .
    "$count_unprovable unprovable, " .
    "$count_ok proved, " .
    "$count_failed failed, " .
    "$count_noproof without proof" .
    "\n";

print STDERR $summary;
print TS $summary;


# colored summary comes now from make-status-diff
#
# sleep(1);
# print STDERR "Summary: $pvs_count_total proofs, ",
#     "$count_unprovable unprovable, ",
#     "[1;32m", "$count_ok proved, ", "[m",
#     "[1;31m", "$count_failed failed, ", 
#     "$count_noproof without proof", "[m", 
#     "\n";
