; patches for PVS 4.1 we currently use

(defun make-common-accessor-subtype-judgement (adtdecl domain adt)
  (let* ((*generate-tccs* 'none)
	 (constr (find adtdecl (constructors adt)
		      :key #'arguments :test #'memq))
	 (subtype (mk-expr-as-type (mk-name-expr (recognizer constr))))
	 (tsubtype (typecheck* subtype nil nil nil)))
    (unless (subtype-of? tsubtype domain)
      (let ((jdecl (make-instance 'subtype-judgement
		     :declared-subtype subtype
		     :declared-type (dep-binding-type domain))))
	(typecheck-adt-decl jdecl)
	(put-decl jdecl)))))

(in-package :pvs)

(defun pp-tex (obj stream)
  (let ((*print-pretty* t)
	(*print-readably* nil)
	(*print-escape* nil)
	(*print-right-margin* *latex-linelength*)
	(*tex-symbol-counters* nil)
	(*disable-gc-printout* t))
    ;;(setf (slot-value *standard-output* 'excl::charpos) 0)
    (unwind-protect
	(let* ((str (with-output-to-string (*standard-output*)
		      (pp-tex* obj)))
	       (*in-tex-math-mode* nil)
	       (*pp-tex-column* 0)
	       (*pp-tex-spaces-to-delete* 0)
	       (len (length str))
	       (*pp-tex-newline-list* (tex-get-math-newline-info str 0 len))
	       (*pp-tex-newline-element* nil))
	  (write-string-with-tex-substitutions str 0 len stream))
      (clrhash *latex-id-strings*)
      (clrhash *latex-keyword-strings*)
      (clrhash *latex-funsym-strings*)
      (clrhash *pvs-tex-substitution-hash*))))

(defun latex-sform (sform sfnum stream)
  (let ((par-sforms
	 (when *print-ancestor*
	   (s-forms (current-goal *print-ancestor*)))))
    (if *report-mode*
	(unless (memq sform par-sforms)
	  (format stream "$\\{\\mbox{\\rm ~a}\\}$ & " sfnum)
	  (latex-print (seq-formula sform) stream))
	(let ((old (memq sform par-sforms)))
	  (format stream "$~a\\mbox{\\rm ~a}" (if old "[" "\\{") sfnum)
	  (when (label sform)
	    (format stream " (~{~a~^, ~})"
	      (mapcar #'latex-protect (label sform))))
	  (format stream "~a$ &" (if old "]" "\\}"))
	  (latex-print (seq-formula sform) stream)))))

(defun latex-protect (name)
  (let* ((nstring (cond ((stringp name)
			 name)
			((symbolp name)
			 (string name))
			(t (coerce name 'string))))
	 (len (length nstring)))
    (labels ((latex-protect* (string pos result)
	       (if (< pos len)
		   (latex-protect*
		    string (1+ pos)
		    (let ((ch (char string pos)))
		      (case ch
			((#\# #\$ #\% #\& #\_ #\{ #\})
			 (cons ch (cons #\\ result)))
			;; \ ==> \char92
			(#\\ (append '(#\2 #\9 #\r #\a #\h #\c #\\) result))
			;; ^ ==> \char94
			(#\^ (append '(#\4 #\9 #\r #\a #\h #\c #\\) result))
			;; ~ ==> \char126
			(#\~ (append '(#\6 #\2 #\1 #\r #\a #\h #\c #\\) result))
			(t (cons ch result)))))
		   (coerce (nreverse result) 'string))))
      (latex-protect* nstring 0 nil))))

(defmethod pp-tex* ((ex application))
  (let ((operator (get-pp-operator* (operator ex)))
	(args (get-pp-argument* (operator ex) (list (argument ex)))))
    (pprint-logical-block (nil nil)
      (pprint-indent :current 2)
      (if (and (zerop (parens operator))
	       (< (precedence operator 'left)
		  (precedence (car args) 'right)))
	  (progn (pp-tex-id '\()
		 (pp-tex* operator)
		 (pp-tex-id '\)))
	  (pp-tex* operator))
      (pprint-indent :block 4)
      (unless *in-tex-math-mode*
	(if (simple-name? operator)
	    (pprint-newline :miser)
	    (pprint-newline :fill)))
      (pp-tex-arguments-list args))))

(defmethod get-pp-operator* ((expr mixfix-branch))
  expr)

(defmethod get-pp-argument* ((expr mixfix-branch) &optional args)
  args)

