(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 16.8.01 by Hendrik
 *
 * Time-stamp: <Monday 8 October 01 17:58:00 tews@ithif51>
 *
 * type and utility functions for free unique type variables
 *
 * $Id: type_variable.ml,v 1.5 2002-05-03 15:01:20 tews Exp $
 *
 *)



type t = int

let next_free = ref(min_int)

let fresh() =
  let res = !next_free 
  in
    incr next_free;
    assert(!next_free <> min_int);
    res


let eq t1 t2 = t1 = t2

let string_of_tv t = "`" ^ string_of_int(t - min_int +1)

let number_of_free_variables () = !next_free - min_int

(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)

