(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 17.6.99 by Hendrik
 *
 * Time-stamp: <Monday 8 October 01 17:58:00 tews@ithif51>
 *
 * the ccsl interface theory
 *
 * $Id: interface_theory.ml,v 1.8 2002/01/24 14:44:00 tews Exp $
 *
 *)

open Util
open Global
open Top_variant_types
open Name_space
open Names
open Top_names
open Logic_util
open Classtypes
open Types_util
open Theory_class
open Pre_printing
;;

  
(***********************************************************************
 ***********************************************************************
 *
 * Interface theory: new version with a set of coalgebras
 * 
 * old version is below
 *
 *)

class ['class_type, 'member_type] ccsl_pre_interface_theory 
  (cl : 'class_type) 
  (* the equality relation for initializing the name space *)
  (eq_types : ('class_type, 'member_type) top_pre_types
     -> ('class_type, 'member_type) top_pre_types -> bool)

  : ['class_type, 'member_type] ccsl_pre_class_theory_type =
  object (self : 'self)

    inherit 
      ['class_type, 'member_type] ccsl_pre_class_theory_class cl eq_types
      as top_theory

       (* reserve all names, that we want to declare *)
    initializer reserve ns 
      (
       	[ name_of_coalgebra; 
	  name_of_method_functor cl
       	]
	@ 
	if cl#has_constructors then [name_of_constructor_functor cl]
	else []
      )

    (*******************************************************************
     *
     * override section
     * 
     * the functors get defined in this theory, therefore we have to 
     * change algebra_type and coalgebra_type
     * this in turn affects algebra_decl and coalgebra_decl
     *)      

    method coalgebra_type =
      IFace( cl, Isabelle_only,self#simple_arguments)

    method algebra_type =
      TypeConstant(name_of_constructor_functor cl, Isabelle_only,
		   self#simple_arguments)

    (*******************************************************************
     *
     * standard section
     * 
     *)

    method get_name = ccsl_interface_theory_name cl

    method get_parameters = self#simple_parameters 

    initializer top_theory#override_file_name (ccsl_class_file_name cl)

    method get_proofs = []


    method private user_imports = cl#get_iface_imports 

    method private component_imports = 
      List.fold_right
	(fun (v,c,args) accu -> 
	   (match c#get_kind with
	      | Spec_class -> 
		  if c#has_feature FinalSemanticsFeature
		  then (ccsl_final_theory_name c, args) :: accu
		  else (ccsl_loose_theory_name c, args) :: accu
	      | Spec_adt -> 
		  (match !output_mode with
		     | Isa_mode -> (ccsl_adtutil_theory_name c, args) :: accu
		     | Pvs_mode -> (ccsl_adt_theory_name c, args) :: accu
		  )
	      | Spec_sig -> 
		  let subst = make_substitution c#get_parameters args 
		  in
		    (List.map 
		       (fun (name,args) ->
			  (name, 
			   substitute_arguments_types_only
			     eq_types subst args)
		       )
		       c#get_iface_imports
		    )
		    @ accu
	      | Spec_Spec -> (assert(false); raise Internal_error)
	   ))
	cl#get_components []
			  

    method private super_imports = 
      List.map 
	(fun ianc -> 
	   ccsl_basic_theory_name ianc, self_argument:: ianc#get_arguments)
	cl#get_resolved_ancestors

    method private functor_declaration = 
      [Comment("Declare coalgebraic signature for class " ^ cl#get_name);
       Typedecl(self#simple_parameters,
		name_of_method_functor cl, self#get_method_functor_type)
      ]

    method private constructor_declaration = 
      if cl#has_constructors then
      	[Comment("Declare constructor signature for class " ^ cl#get_name);
	 Typedecl(self#simple_parameters,
		  name_of_constructor_functor cl, 
		  self#get_constructor_functor_type)
      	]
      else 
	[Comment("Class " ^ cl#get_name ^ " has no constructors")]


    method private struct_of =
      let sub_ns = sub_space ns in 
      let method_name m = (("o_" ^ m#get_name), m#get_full_type) in
      let pre_anc_mems = 
	List.map 
	  (fun acl -> List.map method_name acl#get_all_sig_actions)
	  cl#get_resolved_ancestors
      in let anc_mems = 
	  List.map (create_ids_with_preference sub_ns) pre_anc_mems in
      let pre_mems = List.map method_name cl#get_sig_actions in
      let mems = create_ids_with_preference sub_ns pre_mems in
      let do_ancestor anc ancmems =
	let body = match ancmems with
	  | [(id,_)] -> Term(id,Always,[])
	  | mlist -> Tuple(List.map (fun (id,_) -> Term(id,Always,[]))
			     mlist)
	in
	  (super_label anc, 
	   Application(
	     Term(name_of_struct_of anc, Always,[]),
	     body))
      in
      let do_method m (id,_) = (method_label m, Term(id,Always,[]))
      in
	Defn(name_of_struct_of cl,
	     [List.map (fun (name,typ) -> Undeclared(name,typ)) 
		((List.flatten anc_mems) @ mems)
	     ],
	     IFace( cl, Isabelle_only, self#simple_arguments),
	     RecordTuple(
	       (List.map2 do_ancestor cl#get_resolved_ancestors anc_mems)
	       @
	       (List.map2 do_method cl#get_sig_actions mems)
	     ))


	(* collect inherited methods for class acl,
	 * they are inherited via path starting in super
         *)
    method private inherited_methods super acl = 
        (* utility function to do one method of acl *)
      let do_method m =
	Defn( m#get_name, 
	      [[Declared(name_of_coalgebra, self#coalgebra_type)]],
	      Function(m#get_domain,m#get_codomain),
	      RecordSelection( m#last_name,
			       Application(Term(super_access_method(super),
						Always,[]), 
					   coalgebra_term)))
      in
	List.map (fun m -> do_method m) acl#get_actions


    method private all_inherited_methods = 
      let ancestor_flatten = 
	List.map (function
		    | Resolved_renaming (_,args,_,ianc) -> ianc
				(* no other stuff *)
		    | Unresolved_renaming _
		    | Resolved_ancestor _ 
		    | Unresolved_ancestor _ -> 
			(assert(false); raise Internal_error)
		 ) in
         (* cl_list comes reversed ! *)
      let ancestor_abbrev_comment cl_list = 
      	Comment( List.fold_right
		   (fun cl s -> s ^ cl#get_name ^ " ")
		   cl_list
		   "Inherited via " 
	       )
      in
          (* do indirect ancestors from acl
	   * they are coming to this class (cl) via cl_path
	   * the last element of cl_path is super
	   *)
      let rec recurse super cl_path acl = 
	(ancestor_abbrev_comment (acl::cl_path)) 
	:: self#inherited_methods super acl
	@  List.flatten(List.map (recurse super (acl::cl_path))
			  (ancestor_flatten acl#get_ancestors))
      in 
	List.flatten (List.map (fun acl -> recurse acl [] acl)
		       (ancestor_flatten cl#get_ancestors))
	    


    method private do_definitions =
      List.map
	(fun def ->
	   let mem = def.defined_method 
	   in
	     match def.definition with
	       | Symbolic eq ->
		   let pretty_eq =
		     ccsl_pre_pretty_formula cl
		       self#get_member_fun self#get_iface_fun eq
		   in 
		     Defn(mem#get_name,
			  [[Declared(name_of_coalgebra, self#coalgebra_type)]],
			  Function(mem#get_domain,mem#get_codomain),
			  Abstraction(
			    List.map (fun id -> (id.id_token.token_name,
						 id.id_type))
					def.variables,
					(Expression pretty_eq)
			  ))
	       | _ -> assert(false); raise Internal_error		    
	)
	cl#get_definitions

    method make_body =
      Import( 
	(match !output_mode with
	   | Pvs_mode -> []
	   | Isa_mode -> [isabelle_top_theory, []])
	@
	self#component_imports @ self#super_imports @ self#user_imports)
	::
      self#functor_declaration
      @
      self#constructor_declaration
      @
      [self#struct_of]
      @
      [self#coalgebra_decl]
      @ (
	if cl#get_ancestors <> [] then 
       	  ((Comment "Inherit method from super classes") ::
       	     self#all_inherited_methods)
	else []
      ) @ (
	if cl#get_definitions <> [] 
	then
	  (Comment "Definitional extensions") ::
	  self#do_definitions
	else
	  []
      )
end

class ccsl_interface_theory cl = 
  [ccsl_iface_type, ccsl_member_type] ccsl_pre_interface_theory cl 
  eq_ccsl_types 


(* class ['class_type, 'member_type] old_ccsl_pre_interface_theory 
 *   (cl : 'class_type) 
 *   (* the equality relation for initializing the name space *)
 *   (eq_types : ('class_type, 'member_type) top_pre_types
 * 	-> ('class_type, 'member_type) top_pre_types -> bool)
 * 
 *   : ['class_type, 'member_type] ccsl_pre_class_theory_type =
 *   object (self : 'self)
 * 
 *     inherit 
 * 	 ['class_type, 'member_type] ccsl_pre_class_theory_class cl eq_types
 * 	 as top_theory
 * 
 * 	  (* reserve all names, that we want to declare *)
 *     initializer reserve ns 
 * 	 (
 * 	   [ name_of_coalgebra; 
 * 	     name_of_method_functor cl
 * 	   ]
 * 	   @ 
 * 	   if cl#has_constructors then [name_of_constructor_functor cl]
 * 	   else []
 * 	 )
 * 
 *     (*******************************************************************
 * 	*
 * 	* override section
 * 	* 
 * 	* the functors get defined in this theory, therefore we have to 
 * 	* change algebra_type and coalgebra_type
 * 	* this in turn affects algebra_decl and coalgebra_decl
 * 	*)      
 * 
 *     method coalgebra_type =
 * 	 Function(Self, IFace( cl, Isabelle_only,self#simple_arguments))
 * 
 *     method algebra_type =
 * 	 TypeConstant(name_of_constructor_functor cl, Isabelle_only,
 * 		      self#simple_arguments)
 * 
 *     (*******************************************************************
 * 	*
 * 	* standard section
 * 	* 
 * 	*)
 * 
 *     method get_name = ccsl_interface_theory_name cl
 * 
 *     method get_parameters = self#simple_parameters 
 * 
 *     initializer top_theory#override_file_name (ccsl_class_file_name cl)
 * 
 *     method get_proofs = []
 * 
 * 
 *     method private user_imports = 
 * 	 List.map (fun s -> s,[]) cl#get_iface_imports 
 * 
 *     method private component_imports = 
 * 	 List.map (fun (c,args) -> 
 * 		     (match c#get_kind with
 * 			| Spec_class -> (ccsl_loose_theory_name c, args)
 * 			| Spec_adt ->  (ccsl_adtutil_theory_name c, args)
 * 			| Spec_sig 
 * 			| Spec_Spec -> (assert(false); raise Internal_error)
 * 		     ))
 * 	   cl#get_components
 * 			     
 * 
 *     method private super_imports = 
 * 	 List.map 
 * 	   (function
 * 	      | Resolved_renaming (ifa,args,_,_) -> 
 * 		  ifa#get_name, self_argument::args
 * 					   (* no other stuff *)
 * 	      | Unresolved_renaming _
 * 	      | Resolved_ancestor _ 
 * 	      | Unresolved_ancestor _ -> (assert(false); raise Internal_error)
 * 	   )
 * 	   cl#get_ancestors
 * 
 *     method private functor_declaration = 
 * 	 [Comment("Declare coalgebra functor for class " ^ cl#get_name);
 * 	  Typedecl(self#simple_parameters,
 * 		   name_of_method_functor cl, self#get_method_functor_type)
 * 	 ]
 * 
 *     method private constructor_declaration = 
 * 	 if cl#has_constructors then
 * 	   [Comment("Declare algebra functor for class " ^ cl#get_name);
 * 	    Typedecl(self#simple_parameters,
 * 		     name_of_constructor_functor cl, 
 * 		     self#get_constructor_functor_type)
 * 	   ]
 * 	 else 
 * 	   [Comment("Class " ^ cl#get_name ^ " has no constructors")]
 * 
 * 	     (* declarations for direct ancestors *)
 *     method private super_access = 
 * 	 (* get a variable for Self *)
 * 	 let self_var = create_one_id (sub_space ns) Self in
 * 	     (* untility function for one ancestor *)
 * 	 let do_ancestor anc_cl anc_args = 
 * 	   Defn(super_access_method anc_cl,
 * 		[[Declared(name_of_coalgebra, self#coalgebra_type)]],
 * 		Function(Self,
 * 			 IFace(anc_cl,Always,self_argument :: anc_args)),
 * 		   Abstraction(
 * 		     [self_var, Self],
 * 		     Application(
 * 		       Term(super_label anc_cl,Always,[]),
 * 		       Application(coalgebra_term, Term(self_var,Always,[])))))
 * 	 in
 * 	   if cl#get_ancestors <> [] 
 * 	   then 
 * 	     (Comment("Define projections for super classes")) ::
 * 	     List.map 
 * 	       (function
 * 		  | Resolved_renaming (_,args,_,ianc) -> 
 * 		      do_ancestor ianc args
 * 			(* no other  stuff *)
 * 		  | Unresolved_renaming _
 * 		  | Resolved_ancestor _ 
 * 		  | Unresolved_ancestor _ -> 
 * 		      (assert(false); raise Internal_error)
 * 	       )
 * 	       cl#get_ancestors
 * 	   else 
 * 	     [Comment("Class " ^ cl#get_name ^ " has no superclasses")]
 * 
 * 
 * 	   (* collect method abbreviations for class cl *)
 *     method private method_abbreviations = 
 * 	   (* utility function to do one method of cl *)
 * 	 let do_method m =
 * 	   let sub_ns = sub_space ns in
 * 	   let argtypes = member_arg_list m in
 * 	   let arglist = create_ids sub_ns argtypes in
 * 	     (* we assume here that self is at first position *)
 * 	   let sv,_ = List.hd arglist in
 * 	   let inner_expr =
 * 	     Application( Term(method_label m,Always,[]), 
 * 			 Application(coalgebra_term,Term(sv,Always,[])))
 * 	   in 
 * 	     Defn( m#get_name, 
 * 		   [[Declared(name_of_coalgebra, self#coalgebra_type)]],
 * 		   Function(m#get_domain,m#get_codomain),
 * 		   Abstraction(
 * 		     arglist,
 * 		     match List.tl arglist with
 * 		       | [] -> inner_expr
 * 			    (* fiddle around one tuples, see get_curried_type *)
 * 		       | [(a,t)] -> 
 * 			   Application(
 * 			     inner_expr,
 * 			     Term(a,Always,[]))
 * 		       | many_args ->
 * 			   Application(
 * 			     inner_expr,
 * 			     Tuple(
 * 			       List.map
 * 				     (fun (v,t) -> Term(v,Always,[]))
 * 				     many_args))))
 * 	 in
 * 	   List.map (fun m -> do_method m) cl#get_actions
 * 
 * 
 * 	   (* collect inherited methods for class acl,
 * 	    * they are inherited via path starting in super
 * 	    *)
 *     method private inherited_methods super acl = 
 * 	   (* utility function to do one method of acl *)
 * 	 let do_method m =
 * 	   Defn( m#get_name, 
 * 		 [[Declared(name_of_coalgebra, self#coalgebra_type)]],
 * 		 Function(m#get_domain,m#get_codomain),
 * (* Hendrik: find solution for this QualifiedTerm *)	      
 * 			     (* Qualified term for pvs not neccessary *)
 * 		 Application(QualifiedTerm(
 * 			       ccsl_interface_theory_name super,
 * 			       Always,[],
 * 			       m#get_name), 
 * 			     Application(Term(super_access_method(super),
 * 					      Always,[]), 
 * 					 coalgebra_term)))
 * 	 in
 * 	   List.map (fun m -> do_method m) acl#get_actions
 * 
 * 
 *     method private all_inherited_methods = 
 * 	 let ancestor_flatten = 
 * 	   List.map (function
 * 		       | Resolved_renaming (_,args,_,ianc) -> ianc
 * 				   (* no other stuff *)
 * 		       | Unresolved_renaming _
 * 		       | Resolved_ancestor _ 
 * 		       | Unresolved_ancestor _ -> 
 * 			   (assert(false); raise Internal_error)
 * 		    ) in
 * 	    (* cl_list comes reversed ! *)
 * 	 let ancestor_abbrev_comment cl_list = 
 * 	   Comment( List.fold_right
 * 		      (fun cl s -> s ^ cl#get_name ^ " ")
 * 		      cl_list
 * 		      "Inherited via " 
 * 		  )
 * 	 in
 * 	     (* do indirect ancestors from acl
 * 	      * they are coming to this class (cl) via cl_path
 * 	      * the last element of cl_path is super
 * 	      *)
 * 	 let rec recurse super cl_path acl = 
 * 	   (ancestor_abbrev_comment (acl::cl_path)) 
 * 	   :: self#inherited_methods super acl
 * 	   @  List.flatten(List.map (recurse super (acl::cl_path))
 * 			     (ancestor_flatten acl#get_ancestors))
 * 	    in 
 * 	   List.flatten(List.map (fun acl -> recurse acl [] acl)
 * 			  (ancestor_flatten cl#get_ancestors))
 * 	       
 * 
 * 
 *     method make_body =
 * 	 Import( 
 * 	   (match !output_mode with
 * 	      | Pvs_mode -> []
 * 	      | Isa_mode -> [isabelle_top_theory, []])
 * 	   @
 * 	   self#user_imports @ self#component_imports @ self#super_imports)
 * 	   ::
 * 	 self#functor_declaration
 * 	 @
 * 	 self#constructor_declaration
 * 	 @
 * 	 [self#coalgebra_decl]
 * 	 @
 * 	 self#super_access
 * 	 @
 * 	 ((Comment( "Method abbreviations for " ^ cl#get_name ))
 * 	  :: (self#method_abbreviations))
 * 	 @
 * 	 if cl#get_ancestors <> [] then 
 * 	   ((Comment "Inherit method from super classes") ::
 * 	    self#all_inherited_methods)
 * 	 else []
 * 
 * end
 * 
 * class old_ccsl_interface_theory cl = 
 *   [ccsl_iface_type, ccsl_member_type] old_ccsl_pre_interface_theory cl 
 *   eq_ccsl_types 
 * 
 *)



(***********************************************************************
 ***********************************************************************
 *
 * Coadt Theory
 *
 *)

class ['class_type, 'member_type] ccsl_pre_coadt_theory 
  (cl : 'class_type) 
  (* the equality relation for initializing the name space *)
  (eq_types : ('class_type, 'member_type) top_pre_types
     -> ('class_type, 'member_type) top_pre_types -> bool)

  : ['class_type, 'member_type] ccsl_pre_class_theory_type =
  object (self : 'self)

    inherit 
      ['class_type, 'member_type] ccsl_pre_class_theory_class cl eq_types
      as top_theory

       (* reserve all names, that we want to declare *)
    initializer reserve ns []

    method get_name = ccsl_coadt_theory_name cl

    method get_parameters = []

    initializer top_theory#override_file_name (ccsl_class_file_name cl)

    method get_proofs = []

    method make_body =
      [Import(
	 [
	   ccsl_basic_theory_name cl, [];
	   ccsl_greatest_invariance_theory_name cl, []
	 ]
       @ 
       (if cl#has_feature HasFullRelLiftingFeature 
       then [ccsl_greatest_bibisim_theory_name cl,[]]
       else [])
       @
       (if cl#has_feature HasMorphismFeature
	then [ccsl_morphism_rewrite_theory_name cl,[];
	      ccsl_finality_theory_name cl,[]]
	else [])
       @
       (if cl#has_feature FinalSemanticsFeature
	then [ccsl_final_props_theory_name cl,[]]
	else [ccsl_loose_theory_name cl, []])
       @
       (if cl#has_feature HasMapFeature
	then [ccsl_map_struct_theory_name cl,[];
	      ccsl_map_theory_name cl,[]]
	else [])
       )]

end

class ccsl_coadt_theory adt = 
  [ccsl_iface_type, ccsl_member_type] ccsl_pre_coadt_theory adt eq_ccsl_types


(***********************************************************************
 ***********************************************************************
 *
 * Loose Coadt Theory
 *
 *)

class ['class_type, 'member_type] ccsl_pre_loose_theory 
  (cl : 'class_type) 
  (* the equality relation for initializing the name space *)
  (eq_types : ('class_type, 'member_type) top_pre_types
   -> ('class_type, 'member_type) top_pre_types -> bool)
  
  : ['class_type, 'member_type] ccsl_pre_class_theory_type =
object (self : 'self)
  
  inherit 
    ['class_type, 'member_type] ccsl_pre_class_theory_class cl eq_types
    as top_theory
      
    (* set file name *)
  initializer 
    top_theory#override_file_name (ccsl_class_file_name cl)
      
    (* reserve all names, that we want to declare *)
  initializer reserve ns 
    [(name_of_loose_type cl)]
    
  method get_name = ccsl_loose_theory_name cl
		      
  method get_parameters = orig_parameters
			    
  method get_proofs = []
			
  method private ltype = TypeConstant((name_of_loose_type cl),Always,[])
			   
  method private loose_args =
    TypeArgument(self#ltype) :: orig_arguments
      
  method private lcoalg_type = 
    Predtype(Formula(
	       Term(name_of_assert cl,
		    Always,self#loose_args)))

  method private lalg_type = 
    Predtype(Formula(
	       Application(
		 Term(name_of_creation cl,Always,
		      self#loose_args),
		 Term(name_of_loose_coalgebra cl, Always,[])
	       )))

  method private coalg_model_axiom =
    Axiom(
      name_of_loose_coalg_axiom,
      Exists(
	[name_of_coalgebra, IFace( cl, Always, self#loose_args)],
	Formula(
	  Application(
	    Term(name_of_assert cl,Always,[]),
	    coalgebra_term
	))))
	    
	    
  method private alg_model_axiom =
    Axiom(
      name_of_loose_alg_axiom,
      Exists(
	[name_of_algebra,
	 TypeConstant(name_of_constructor_functor cl,
		      Always,
		      self#loose_args)],
	Formula(
	  Application(
	    Application(
	      Term(name_of_creation cl,Always,[]),
	      Term(name_of_loose_coalgebra cl, Always, [])),
	    algebra_term))))
	    
  method private loose_private_bisim_eq_decl =
    Defn( name_of_loose_private_bisim_eq cl, [],
	  Function(
	    Product([self#ltype; self#ltype]),
	    Bool),
	  Application(
	    Term(name_of_private_bisim_eq cl, Always, []),
	    Tuple([Term(name_of_loose_coalgebra cl,Always,[])])))
      
  method private loose_public_bisim_eq_decl =
    Defn( name_of_loose_public_bisim_eq cl, [],
	  Function(
	    Product([self#ltype; self#ltype]),
	    Bool),
	  Application(
	    Term(name_of_public_bisim_eq cl, Always, []),
	    Tuple([Term(name_of_loose_coalgebra cl,Always,[])])))
      
  method make_body =
    [Typevardecl (name_of_loose_type cl);
     Import( [ccsl_basic_theory_name cl, self#loose_args]);
     self#coalg_model_axiom;
     Defnuninterpret(name_of_loose_coalgebra cl, [], self#lcoalg_type);
    ]
    @
    if cl#has_constructors 
    then 
      [self#alg_model_axiom;
       Defnuninterpret(name_of_algebra_loose cl, [], self#lalg_type);
      ]
    else 
      []
    
end
  
class ccsl_loose_theory cl = 
  [ccsl_iface_type, ccsl_member_type] ccsl_pre_loose_theory cl eq_ccsl_types


(**********************************************************
 **********************************************************
 *
 *   FINAL MODEL
 *
 *)


class ['class_type, 'member_type] ccsl_pre_final_theory 
  (cl : 'class_type) 
  (* the equality relation for initializing the name space *)
  (eq_types : ('class_type, 'member_type) top_pre_types
   -> ('class_type, 'member_type) top_pre_types -> bool)
  
  : ['class_type, 'member_type] ccsl_pre_class_theory_type =
object (self : 'self)
  
  inherit 
    ['class_type, 'member_type] ccsl_pre_class_theory_class cl eq_types
    as top_theory
      
    (* set file name *)
  initializer 
    top_theory#override_file_name (ccsl_class_file_name cl)
      
    (* reserve all names, that we want to declare *)
  initializer reserve ns 
    [(name_of_final_type cl)]
    
  method get_name = ccsl_final_theory_name cl
		      
  method get_parameters = orig_parameters
			    
  method get_proofs = []
			
  method private ftype = TypeConstant((name_of_final_type cl),Always,[])
			   
  method private final_args =
    TypeArgument(self#ftype) :: orig_arguments
      
  method private do_import =
    Import( 
      [
	ccsl_basic_theory_name cl, self#final_args;
      ]);

  method private fcoalg_type = 
    Predtype(
      Formula(
	Term(name_of_assert cl,
	     Always,
	     TypeArgument(self#ftype) :: orig_arguments));
    )

  method private falg_type = 
    Predtype(Formula(
	       Application(
		 Term(name_of_creation cl,Always,
		      TypeArgument(self#ftype) :: orig_arguments),
		 Term(name_of_final_coalgebra cl, Always,[])
	       )))

  method private coalg_model_axiom =
    Axiom(
      name_of_final_coalg_axiom,
      Exists(
	[name_of_coalgebra, IFace( cl, Always, self#final_args)],
	Formula(
	  Application(
	    Term(name_of_assert cl,Always,[]),
	    coalgebra_term
	))))
	    
	    
  method private alg_model_axiom =
    Axiom(
      name_of_final_alg_axiom,
      Exists(
	[name_of_algebra,
	 TypeConstant(name_of_constructor_functor cl,
		      Always,
		      self#final_args)],
	Formula(
	  Application(
	    Application(
	      Term(name_of_creation cl,Always,[]),
	      Term(name_of_final_coalgebra cl, Always, [])),
	    algebra_term
	  ))))
	    
	    
  method make_body =
    [Typevardecl (name_of_final_type cl);
     self#do_import;
     self#coalg_model_axiom;
     Defnuninterpret(name_of_final_coalgebra cl, [], self#fcoalg_type);
    ]
    @
    if cl#has_constructors 
    then
      [
	self#alg_model_axiom;
	Defnuninterpret(name_of_algebra_final cl, [], self#falg_type);
      ]
    else 
      []
    
end
  
class ccsl_final_theory cl = 
  [ccsl_iface_type, ccsl_member_type] ccsl_pre_final_theory cl eq_ccsl_types


(**********************************************************
 **********************************************************
 *
 *   FINAL MODEL PROPERTIES
 *
 *)


class ['class_type, 'member_type] ccsl_pre_final_props_theory 
  (cl : 'class_type) 
  (* the equality relation for initializing the name space *)
  (eq_types : ('class_type, 'member_type) top_pre_types
   -> ('class_type, 'member_type) top_pre_types -> bool)
  
  : ['class_type, 'member_type] ccsl_pre_class_theory_type =
object (self : 'self)
  
  inherit 
    ['class_type, 'member_type] ccsl_pre_class_theory_class cl eq_types
    as top_theory
      
    (* set file name *)
  initializer 
    top_theory#override_file_name (ccsl_class_file_name cl)
      
    (* reserve all names, that we want to declare *)
  initializer reserve ns 
    []
    
  method get_name = ccsl_final_props_theory_name cl
		      
  method get_parameters = self#simple_parameters
			    
  method get_proofs = []
			
  method private ftype = TypeConstant((name_of_final_type cl),Always,[])
			   
  method private final_args =
    TypeArgument(self#ftype) :: orig_arguments
      
  method private do_import =
    Import( 
      [
	ccsl_final_theory_name cl, orig_arguments;
	ccsl_finality_theory_name cl, self_argument :: self#final_args;
      ]);

  method private coalg_model_axiom =
    Axiom(
      name_of_final_prop_axiom,
      Formula(
	Application(
	  Term(name_of_finality cl,Always,[]),
	  Term(name_of_final_coalgebra cl, Always, [])
	)))
	    
	    
  method make_body =
    [
     self#do_import;
     self#coalg_model_axiom;
    ]
end
  
class ccsl_final_props_theory cl = 
  [ccsl_iface_type, ccsl_member_type] ccsl_pre_final_props_theory 
  cl eq_ccsl_types




(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** End: ***)
