(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 26.1.99 by Hendrik
 *
 * Time-stamp: <Monday 8 October 01 17:58:00 tews@ithif51>
 *
 * Utility functions and variables used in _all_ parsers
 *
 * $Id: parser_util.mli,v 1.4 2002/01/23 16:00:23 tews Exp $
 *
 *)

open Top_variant_types;;
open Top_classes;;

(* some state Variables for the parser *)

    (* current line number *)
val line : int ref

    (* absolute position of the start of the current line *)
val line_start : int ref


    (* adopt state vars after a newline parsed *)
val newline : int -> unit

    (* reset the line number to one again *)
val reset_line : unit -> unit


    (* build a token for the current line, if there is no 
     * token available in the context 
     *)
val emergency_token : unit -> token_type


(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** End: ***)

