(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 14.5.99 by Hendrik
 *
 * Time-stamp: <Monday 8 October 01 17:58:00 tews@ithif51>
 *
 * the class for ccsl adt's and classes
 *
 * $Id: iface_class.mli,v 1.2 2002/05/03 15:01:09 tews Exp $
 *
 *)

open Top_variant_types
open Classtypes


class ['member_type, 'theory_body_type, 'super_class] ccsl_pre_iface_class :
  token_type ->				(* the name *)
					(* the local symbol table *)
    ('super_class, 'member_type) top_pre_scope_type ->
					(* the prelude flag *)
      bool ->

(* here should come ccsl_pre_iface_type constraining for instance
 * 'member_type to ccsl_member_type ...
 * but there is no concrete syntax for that, so use an ad hoc type
 *)

object
  inherit ['member_type, 'theory_body_type, 'super_class] ccsl_pre_iface_type 

  constraint 'member_type = ccsl_member_type
  constraint 'theory_body_type =
    (ccsl_iface_type, ccsl_member_type) ccsl_pre_theory_body_type
  constraint 'super_class = ccsl_iface_type
end



(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)

