(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 14.5.99 by Hendrik
 *
 * Time-stamp: <Saturday 11 May 02 19:24:32 tews@ithif56.inf.tu-dresden.de>
 *
 * utility functions for pvs proofs
 *
 * $Id: pvs_proof_util.mli,v 1.4 2002/05/22 13:42:46 tews Exp $
 *
 *)

open Top_variant_types;;

(*******************************************************************
 * utility functions to built proofs
 *)

val make_simple_proof : lisp_expr list -> pvs_proof_tree


(*******************************************************************
 * PVS proof commands in alphabetical order 
 * 
 * there is more implemented in the ml file, check and export it, 
 * when needed
 *)

val pvs_assert : lisp_expr

val auto_rewrite : string list -> lisp_expr

val auto_rewrite_defs : lisp_expr

  (* give theories to auto-rewrite with *)
val auto_rewrite_theories : string list -> lisp_expr

val case : string -> lisp_expr

  (* name to expand *)
val expand : string -> lisp_expr

val expand_num : string -> int -> lisp_expr

val extensionality : lisp_expr

val fail : lisp_expr

val flatten : lisp_expr

    (* (FLATTEN -) *)
val flatten_antecedent : lisp_expr

val grind : lisp_expr

val hide_nums : int list -> lisp_expr

val hide_all_but : int list -> lisp_expr

val induct : string -> lisp_expr

    (* (SKOLEM!) *)
val skolem_bang : lisp_expr

    (* (INST?) *)
val inst_question : lisp_expr

    (* (INST? i) *)
val inst_num : int -> lisp_expr

(* instatiation with the given string, in the formula with the given position *)
val inst_val : int -> string -> lisp_expr

val lemma : string -> lisp_expr

val liftif : lisp_expr

val liftif_num : int -> lisp_expr

val name : string -> string -> lisp_expr

val split : lisp_expr

val split_num : int -> lisp_expr

val postpone : lisp_expr

val reduce : lisp_expr

val replace_num : int -> lisp_expr

val branch : lisp_expr -> lisp_expr list -> lisp_expr

val repeat : lisp_expr -> lisp_expr

val rewrite : string -> lisp_expr

  (* do a RL rewrite *)
val rewrite_left : string -> lisp_expr

val skosimp : lisp_expr

val skosimp_star : lisp_expr

val type_pred : string -> lisp_expr

val use : string -> lisp_expr


(************************************************************************
 * utility functions to built proofs
 *)

val pvs_skolem : string -> string

(************************************************************************
 * more complicated strategies
 *)


(* tries command_list on every assumption.
 *
 * 	(APPLY (REPEAT
 * 		(TRY (THEN command_list) (HIDE -1)
 * 		 (HIDE -1)))))
 *)


val try_on_every_assumption : lisp_expr list -> lisp_expr

(* super_inst
 *
 * instanciates a list in the antecedent until we hit the right 
 * one. If something goes wrong we try the next sequent
 *
 * 	(APPLY (REPEAT
 * 		(TRY (BRANCH (INST? -1) ((SKIP) (FAIL))) (HIDE -1)
 * 		 (HIDE -1)))))
 *)
(*
val super_inst : lisp_expr
*)



(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)

