(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 14.5.99 by Hendrik
 *
 * Time-stamp: <Sunday 19 May 02 20:02:34 tews@ithif56.inf.tu-dresden.de>
 *
 * The class for ccsl constructors, attributes and methods
 *
 * $Id: member_class.ml,v 1.15 2002/05/22 13:42:41 tews Exp $
 *
 *)

open Util
open Top_variant_types
open Top_classes
open Types_util
open Classtypes
;;

class ['class_type, 'member_type] ccsl_pre_member_class 
  iface name old_names domain codomain visibility sort 
  : ['class_type, 'member_type] ccsl_pre_member_type
  = 
  object (self : 'self)
    inherit ['class_type, 'member_type] top_pre_member_class 
      name old_names domain codomain visibility sort 
      as top_member

    constraint 'class_type = 
	       < dump_iface : string; get_name : string; .. >

    (*******************************************************************
     * 
     * general functions
     *)
  
    method get_full_type = 
      match self#get_sort with
	| Proper_Attribute _
	| Normal_Method
	| Update_Method
	| Defined_Method
	| Var_Constructor
	| Adt_Var_Constructor -> Function(domain, codomain)

	| Adt_Const_Constructor
	| Const_Constructor 

	| Adt_Accessor 
	| Adt_Recognizer 
	| Adt_Reduce
	| Class_Coreduce 
	| Class_Special

	| GroundTerm
	| InfixGroundTerm
	  -> codomain


    method get_curried_type = match domain with
      | Self -> codomain
      | Product([Self;typ]) -> Function(typ, codomain)
      | Product(Self :: domtl) ->
	  Function(Product(domtl), codomain)
      | _ -> assert(false)

    method hosting_class = (iface : 'class_type)


    (*******************************************************************
     *
     * Renaming
     *)

	(* override*)
    method rename_member new_name = 
      let local = self#hosting_class#get_local in
      let symbol = Symbol.find_local local self#get_name in
	Symbol.delete_local local self#get_name;
	top_member#rename_member new_name;
	Symbol.create_local local self#get_name (symbol)


    (*******************************************************************
     *
     * Class stuff
     *)
	    
    method needs_lifting =
      has_successor_state(Function(domain, codomain))


    method register_update_method umethod =
      match sort with
	| Proper_Attribute None -> sort <- Proper_Attribute (Some umethod)
	| _ -> assert(false)

    method get_update_method =
      match sort with
	| Proper_Attribute (Some m) -> m
	| _ -> assert(false)


    (*******************************************************************
     *
     * Adt stuff
     *)
	    
    val mutable accessors = ([] : 'member_type list)
			      
    method register_accessors acs = 
      assert(self#is_adt_constructor);
      accessors <-  acs
	
    method get_accessors = 
      let name = self#get_name in
      assert(self#is_adt_constructor);
      accessors
	
    method get_ith_accessor i = 
      assert(self#is_adt_constructor);
      assert((List.length accessors) > i); 
      List.nth accessors i 
	
    val mutable recognizer = (None : 'member_type option)

    method register_recognizer reco =
      assert(self#is_adt_constructor);
      recognizer <- Some reco

    method get_recognizer = 
      assert(self#is_adt_constructor);
      match recognizer with
	| Some r -> r
	| None -> assert(false)
	
    (*******************************************************************
     *
     * Ground signature stuff
     *)

    val mutable local_parameters = 
      ([] : ('class_type, 'member_type) top_pre_parameter_type list)

    method set_local_parameters locps = 
      assert(sort = GroundTerm || sort = InfixGroundTerm);
      local_parameters <- locps

    method get_local_parameters = local_parameters
  end



(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)





