(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 26.1.99 by Hendrik
 *
 * Time-stamp: <Wednesday 8 May 02 11:41:09 tews@ithif51>
 *
 * Utility functions and variables used in _all_ parsers
 *
 * $Id: parser_util.ml,v 1.5 2002/05/22 13:42:46 tews Exp $
 *
 *)

(***********************************************************************
 ***********************************************************************
 *
 * module implementation
 *
 *)

open Top_variant_types;;

    (* the current input file *)
let current_file = ref ""

    (* current line number
     *)
let line = ref 1

    (* holds the global byte offset wrt the current file of the
     * start of the current line
     *)
let line_start = ref 0

    (* lexer action when newline is read in
     *)
let newline pos = incr(line); line_start := pos

    (* the state of this module:
     * line number, position of line start, file name
     *)
type state_type = (int * int * string)

    (* get the complete parser_util state *)
let get_state () = (!line, !line_start, !current_file)

    (* set the complete parser_util state *)
let set_state (saved_line, saved_line_start, saved_file) =
  line := saved_line;
  line_start := saved_line_start;
  current_file := saved_file

    (* reset the line number to one again. *)
let reset_line file_name = 
  line := 1;
  line_start := 0;
  current_file := file_name

    (* build a token for the current line, if there is no 
     * token available in the context 
     *)
let emergency_token () = 
  { token_name = "";
    loc = None 
  }


(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)

