(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 20.8.03 by Hendrik
 *
 * Time-stamp: <Wednesday 20 August 03 17:28:56 tews@debian>
 *
 * bottom up type derivarion; see comments in newtypecheck.ml
 *
 * $Id: derive.mli,v 1.2 2003/08/21 15:15:05 tews Exp $
 *
 *)

open Top_variant_types
open Classtypes

(***********************************************************************
 *
 * Errors
 *
 *)

exception Typecheck_error

val proj_i_error : 
  ccsl_expressions -> location_type -> ccsl_input_types -> unit

val proj_dom_error : location_type -> ccsl_input_types -> unit


(***********************************************************************
 *
 * type variable management
 *
 *)

type tv_binding_type

val new_tv_binding : unit -> tv_binding_type

val normalize_type : tv_binding_type -> ccsl_input_types -> ccsl_input_types

val normalize_args : tv_binding_type -> 
  ccsl_argument_type list -> ccsl_argument_type list


(***********************************************************************
 *
 * type unification
 *
 *)

val types_must_unify : ccsl_output_types -> ccsl_output_types -> bool

val unify_types : 
  tv_binding_type -> ccsl_input_types -> ccsl_input_types
  -> (ccsl_input_types -> ccsl_input_types -> unit) 
    -> ccsl_input_types


(***********************************************************************
 *
 * type derivation
 *
 *)

val derive_definition_expression :
  ccsl_iface_type -> location_type -> tv_binding_type 
  -> ccsl_input_types -> ccsl_expressions -> ccsl_expressions


val derive_assertion_formula :
  ccsl_iface_type -> location_type -> tv_binding_type 
  -> ccsl_formulas -> ccsl_formulas



(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)
