(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 14.5.99 by Hendrik
 *
 * Time-stamp: <Friday 10 May 02 13:20:03 tews@ithif51>
 *
 * ccsl symboltable
 *
 * $Id: symbol.mli,v 1.8 2002/05/22 13:42:43 tews Exp $
 *
 *)


open Top_variant_types
open Classtypes;;

(***********************************************************************
 *
 * Types are defined in ccsl_classtypes.ml
 *
 * 
 * type ccsl_symbol_table_type =
 *     (top_name_space, ccsl_shape_type, ccsl_symbol_type) Table.global
 * 
 * type ccsl_scope_type =
 *     (top_name_space, ccsl_shape_type, ccsl_symbol_type) Table.local
 * 
 *)


(***********************************************************************
 * the global symboltable
 *)

val ccsl_gst : ccsl_symbol_table_type


(***********************************************************************
 *
 * conviniece functions for the symboltable
 *
 *)

    (*******************************************************************
     *
     * Creating entries in the global Table
     *)
	(* (create name x) creates an new entry for name in 
	   table, possibly hiding other entries
	 *)
val create : string -> 
                (* ccsl_shape_type -> *) ccsl_symbol_type -> unit 


    (*************************************************************************
     *
     * Creating a new local (= block) table, without changing the global 
     * symbol table. This is neccessary in special cases, ccsl class 
     * instanciation for instance.
     * 
     * For manageing scopes you should use start_block/close_block, see below
     *)
val new_local : unit -> ccsl_scope_type


    (*******************************************************************
     *
     * adding entries to a local table
     *)

val create_local : ccsl_scope_type -> string -> 
                      (* ccsl_shape_type  -> *) ccsl_symbol_type -> unit


    (*******************************************************************
     *
     * finding entries in the global table
     *)
	(* look for a symbol in the hope it is not overloaded
	   raise Overloaded if it is overloaded
	 *)
val find : string -> ccsl_symbol_type


	(* find all symbols of a given name *)
val find_all : string -> (ccsl_shape_type*ccsl_symbol_type) list



    (*******************************************************************
     *
     * finding entries in local tables
     *)

	(* do lookup in a local table *)
val find_local : ccsl_scope_type -> string -> ccsl_symbol_type


    (*******************************************************************
     *
     * deleting entries from a local tables
     *)

val delete_local : ccsl_scope_type -> string -> unit





    (*******************************************************************
     *
     * managing scopes
     *)
	   (* start a new block -> make entries into a local table 
            * this function actually _creates_ a new local symbol
            * table! Use open_block nesting of scopes in a second 
            * pass
            *)
val start_block : unit -> ccsl_scope_type


	   (* end the definition section of the current block
 	    * make entries into the same block 
	    * like before start_block was called
	    *
	    * return the definitions
	    *)
val end_of_defs : unit -> ccsl_scope_type


	   (* close the current block 
	      *)
val close_block : unit -> ccsl_scope_type


	   (* close the current block 
	      *)
val reset_gst : int -> unit


           (* nesting ccsl_scopes: add this local name space to the global 
            * symboltable, use close_block to remove it
            *)
val open_block : ccsl_scope_type -> unit

       (* return the number of open blocks
        *)
val nesting_size : unit -> int

    (*******************************************************************
     *
     * miscellany
     *)

	   (* iterate over all entries *)
val symbol_table_iter : 
    (top_name_space -> string -> ccsl_shape_type -> ccsl_symbol_type -> unit) 
     -> unit


	   (* print the whole table *)
val symbol_table_dump : (ccsl_symbol_type -> string) -> string


	   (* print a local table *)
val dump_scope : ccsl_scope_type -> 
      (ccsl_symbol_type -> string) -> string


    (***********************************************************************
     *
     * create entries in the symboltable
     *
     *)


val identifier_record :
  token_type -> ccsl_origin_type -> ccsl_identifier_record_type

(* val create_ground_term : ccsl_identifier_record_type -> unit
 * 
 *)
val create_ground_type : ccsl_identifier_record_type -> unit

val create_adt : ccsl_iface_type -> unit

val create_class : ccsl_iface_type -> unit

val create_sig : ccsl_iface_type -> unit

val create_member : ccsl_member_type -> unit

val create_adt_content : ccsl_iface_type -> unit

val create_class_content : ccsl_iface_type -> unit

val create_sig_content : ccsl_iface_type -> unit

val create_type_parameter : ccsl_identifier_record_type -> unit

val create_var : ccsl_identifier_record_type -> unit

val create_var_list : (string * ccsl_input_types) list -> unit







(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)

