(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 19.5.02 by Hendrik
 *
 * Time-stamp: <Monday 4 August 03 10:50:23 tews@debian>
 *
 * The class for ccsl constructors, attributes and methods
 *
 * $Id: member_class.mli,v 1.4 2003-08-21 15:15:03 tews Exp $
 *
 *)

open Top_variant_types
open Classtypes


class ['class_type, 'member_type] ccsl_pre_member_class :
  'class_type ->					    (* hosting iface *)
    token_type ->					      (* the name *)
      token_type list ->				      (* old names *)
	('class_type, 'member_type) top_pre_types ->	      (* domain *)
	  ('class_type, 'member_type) top_pre_types ->	      (* codomain *)
	    top_visibility ->				      (* visibility *)
	      'member_type top_pre_member_sort ->	      (* sort *)

object
  inherit ['class_type, 'member_type] ccsl_pre_member_type

    (* use of Symbol in rename_member spoils the typing *)
  constraint 'class_type = <get_local : ccsl_scope_type; .. >

  (* DELETE
   * 
   * constraint 'member_type = <get_name : string; ..>
   *)

end
      



(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)

