(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 14.5.99 by Hendrik
 *
 * Time-stamp: <Thursday 28 September 06 11:40:53 tews@tandem.cs.ru.nl>
 *
 * strings for ccsl translation
 *
 * $Id: names.mli,v 1.18 2006-09-28 11:34:24 tews Exp $
 *
 *)


val anon_sig_prefix : string


(*******************************************************************
 *
 * theory names
 *)


val ccsl_interface_theory_name : <get_name : string; .. >  -> string

val ccsl_lift_theory_name : <get_name : string; .. > -> string

val ccsl_method_idtype_adt_name : <get_name : string; .. > -> string

val ccsl_method_lift_theory_name : <get_name : string; .. > -> string

val ccsl_private_invariance_rewrite_name : <get_name : string; .. > -> string

val ccsl_public_invariance_rewrite_name : <get_name : string; .. > -> string

val ccsl_method_invariance_rewrite_name: <get_name : string; .. > -> string

val ccsl_method_invariance_inherit_name: <get_name : string; .. > -> string

val ccsl_greatest_invariance_theory_name: <get_name : string; .. > -> string

val ccsl_box_theory_name : <get_name : string; .. > -> string

val ccsl_box_inherit_theory_name : <get_name : string; .. > -> string

val ccsl_step_theory_name : <get_name : string; .. > -> string
    
val ccsl_path_theory_name : <get_name : string; .. > -> string
    
val ccsl_bibisim_theory_name : <get_name : string; .. > -> string

val ccsl_private_bibisim_rewrite_theory_name : <get_name : string; .. > -> string

val ccsl_public_bibisim_rewrite_theory_name : 
  <get_name : string; .. > -> string

val ccsl_bisim_eq_theory_name : <get_name : string; .. > -> string

val ccsl_private_bisim_eq_rewrite_theory_name : 
  <get_name : string; .. > -> string

val ccsl_public_bisim_eq_rewrite_theory_name : 
  <get_name : string; .. > -> string

val ccsl_req_bisim_theory_name : 
  <get_name : string; .. > -> string

val ccsl_definitions_theory_name : <get_name : string; ..> -> string

val ccsl_morphism_theory_name : 
  <get_name : string; .. > -> string

val ccsl_morphism_rewrite_theory_name : 
  <get_name : string; .. > -> string

val ccsl_finality_theory_name : 
  <get_name : string; .. > -> string

val ccsl_coreduce_rewrite_theory_name :
  <get_name : string; .. > -> string

val ccsl_finality_bisim_theory_name : 
  <get_name : string; .. > -> string

val ccsl_map_struct_theory_name : <get_name : string; .. > -> string

val ccsl_map_theory_name : <get_name : string; .. > -> string

val ccsl_semantics_theory_name : <get_name : string; .. > -> string

val ccsl_basic_theory_name : <get_name : string; .. > -> string

val ccsl_coadt_theory_name : <get_name : string; .. > -> string

val ccsl_loose_theory_name : <get_name : string; .. > -> string

val ccsl_final_theory_name : <get_name : string; .. > -> string

val ccsl_final_props_theory_name : <get_name : string; .. > -> string

val ccsl_full_invariant_theory_name : <get_name : string; .. > -> string

val ccsl_map_theory_name : <get_name : string; .. > -> string

val ccsl_full_bibisim_theory_name : <get_name : string; .. > -> string

val ccsl_greatest_bibisim_theory_name : <get_name : string; .. > -> string

val ccsl_theorem_theory_name : <get_name : string; .. > -> string


val ccsl_adt_theory_name : <get_name : string; .. > -> string

val ccsl_adtutil_theory_name : <get_name : string; .. > -> string

val ccsl_adt_every_theory_name : <get_name : string; .. > -> string

val ccsl_adt_rellift_theory_name : <get_name : string; .. > -> string

val ccsl_adt_map_theory_name : <get_name : string; .. > -> string

val ccsl_sig_def_theory_name : <get_name : string; .. > -> string

val ccsl_empty_type_defn_theory_name : string

val ccsl_empty_fun_theory_name : string

val ccsl_power_theory_1_name : string

val ccsl_fpower_theory_1_name : string

val ccsl_power_theory_2_name : string

val ccsl_fpower_theory_2_name : string


(* addons for Isabelle *)

val ccsl_isabelle_addon_theory_name : string

val ccsl_prelude_name : string

(*******************************************************************
 *
 * item names
 *)

val name_of_empty_type : string

val name_of_empty_fun : string

val name_of_power_type : string

val name_of_fpower_type : string

val name_of_power_pred_char : string

val name_of_fpower_pred_char : string

val name_of_member : string

val name_of_fmember : string

val name_of_emptyset : string

val name_of_femptyset : string

val name_of_unique_empty_fun_lemma : string

val name_of_self : string

val name_of_algebra_final: <get_name: string; .. > -> string

val name_of_algebra_loose: <get_name: string; .. > -> string

val name_of_coalgebra : string

val name_of_coalgebra1 : string

val name_of_coalgebra2 : string

val name_of_algebra : string

val name_of_method_id: string
	

(*******************************************************************
 *
 * Powerset and finite powerset names
 *)

(* most of the relevant names are hardwired in the prelude,
 * see above
 *)

val name_of_finite_set_type : string

val name_of_finite_image_lemma : string

val name_of_finite_pred : string



(*******************************************************************
 *
 * Interface names
 *)

val name_of_constructor_functor : <get_name : string; .. > -> string

val super_label : <get_name : string; .. > -> string

val name_of_struct_of : <get_name : string; ..> -> string

val super_access_method : <get_name : string; .. > -> string

val method_label : <get_name : string; .. > -> string

val name_of_method_tag_string : string -> string

val name_of_method_tag : <get_name : string; .. > -> string

val name_of_method_tag_recognizer : <get_name : string; .. > -> string

val constructor_accessor_name : string -> string

val constructor_recognizer : <get_name : string; .. >  -> string

val update_method_name : <get_name : string; .. > -> string

val name_of_independent_assertion : 
  <get_name : string; .. > -> <get_name : string; .. > -> string

val name_of_update_assertion : 
  <get_name : string; .. > -> <get_name : string; .. > -> string

val name_of_loose_coalg_axiom : string

val name_of_loose_alg_axiom : string

val name_of_final_coalg_axiom : string

val name_of_final_prop_axiom : <get_name : string; .. > -> string

val name_of_final_alg_axiom : string

val name_of_full_class_pred :  <get_name : string; .. > -> string

val name_of_full_public_class_pred :  <get_name : string; .. > -> string

val name_of_public_class_pred :  <get_name : string; .. > -> string

val name_of_method_class_pred: <get_name : string; .. > -> string
		
val name_of_private_class_rel :  <get_name : string; .. > -> string

val name_of_public_class_rel :  <get_name : string; .. > -> string

val name_of_full_class_rel : <get_name : string; .. > -> string

val name_of_full_public_class_rel : <get_name : string; .. > -> string

val name_of_class_map_struct : <get_name : string; ..> -> string

val name_of_admissable_map_fun_pred : <get_name : string; ..> -> string


val name_of_equivalence : string

val lifting_name_prefix : string

val name_of_private_bibisimulation :  <get_name : string; .. > -> string

val name_of_private_struct_bibisimulation :  <get_name : string; .. > -> string

val name_of_public_bibisimulation :  <get_name : string; .. > -> string

val name_of_private_bibisim :  <get_name : string; .. > -> string

val name_of_public_bibisim :  <get_name : string; .. > -> string

val name_of_public_bisimulation_eq :  <get_name : string; .. > -> string

val name_of_private_bisimulation_eq :  <get_name : string; .. > -> string

val name_of_public_bisim_eq :  <get_name : string; .. > -> string

val name_of_private_bisim_eq :  <get_name : string; .. > -> string

val name_of_loose_public_bisim_eq :  <get_name : string; .. > -> string

val name_of_loose_private_bisim_eq :  <get_name : string; .. > -> string

val name_of_full_bibisimulation : <get_name : string; .. > -> string

val dummy_variable : string

val name_of_full_invariance : <get_name : string; .. > -> string

val name_of_private_invariance : <get_name : string; .. > -> string

val name_of_private_struct_invariance : <get_name : string; .. > -> string

val name_of_public_invariance : <get_name : string; .. > -> string

val name_of_method_invariance : <get_name : string; .. > -> string

val name_of_greatest_invariance: <get_name : string; .. > -> string

val name_of_h_gi: string

val name_of_modal: 
  Top_variant_types.top_modality_type -> <get_name : string; .. > -> string

(* DELETE
 * val name_of_box: <get_name : string; .. > -> string
 * 
 * val name_of_diamond: <get_name : string; .. > -> string
 *)

val name_of_admissible: string

val name_of_admissible_null_lemma: string

val name_of_admissible_linear_lemma: string

val name_of_admissible_append_lemma: string

val name_of_transition: string

val name_of_transition_append_lemma: string

val name_of_transition_at_end_lemma: string

val name_of_invariant_char_lemma: string

val name_of_diamond_transition_lemma: string

val name_of_transition_diamond_lemma: string

val name_of_monotonic: string

val name_of_nonempty: string

val name_of_gfp: string
		
val name_of_set2pred : string

val name_of_pred2set : string

val name_of_initially : <get_name : string; .. > -> string

    (* Use name_of_list_member always with SmartApplication, 
     * because in Isabelle it is curried!!
     *)
val name_of_list_member : unit -> string

val name_of_choose : unit -> string
		
val name_of_assertion_predicate : string -> string

val name_of_assertion_lemma : string -> string

val name_of_inherited_assert_lemma : 
  <get_name : string; .. > -> string

val name_of_creation_predicate : string -> string

val name_of_assert :  <get_name : string; .. > -> string

val name_of_method_assert :  <get_name : string; .. > -> string

val name_of_creation :  <get_name : string; .. > -> string

val name_of_model :  <get_name : string; .. > -> string

val name_of_graph : string

val name_of_gfp : string

(*******************************************************************
 *
 * Invariance Type names
 *)
					
val name_of_method_enum_type : <get_name : string; .. > -> string

val name_of_complete_inv_id_list : <get_name : string; .. > -> string

val name_of_method_pred_type : <get_name : string; .. > -> string


(*******************************************************************
 *
 * Invariance Predicate names
 *)


val name_of_method_predicate : <get_name : string; .. > -> string


(*******************************************************************
 *
 * lemma names
 *)

val name_of_inv_true_lemma  : string

val name_of_inv_and_lemma : string

val name_of_inv_list_lemma : string

val name_of_inv_lemma : <get_name : string; .. > -> string

val name_of_private_bibisim_lemma : <get_name : string; .. > -> string

val name_of_public_bibisim_lemma : <get_name : string; .. > -> string

val name_of_private_bisim_eq_lemma : <get_name : string; .. > -> string

val name_of_public_bisim_eq_lemma : <get_name : string; .. > -> string

val name_of_private_eq_bisim_lemma : string

val name_of_public_eq_bisim_lemma : string

val name_of_private_bisim_refl_lemma : string

val name_of_public_bisim_refl_lemma : string

val name_of_private_bisim_sym_lemma : string

val name_of_public_bisim_sym_lemma : string

val name_of_private_bisim_trans_lemma : string

val name_of_public_bisim_trans_lemma : string

val name_of_private_bisim_equiv_lemma : string

val name_of_public_bisim_equiv_lemma : string

val name_of_inv_linear_cons_lemma: string

val name_of_inv_linear_append_lemma: string

val name_of_gfp_bound_lemma: string

val name_of_greatest_inv_unique_lemma: string

val name_of_h_gi_monotonic_lemma : string

val name_of_greatest_inv_char_lemma : string

val name_of_greatest_inv_exist_lemma :string

val name_of_box_K_lemma: <get_name : string; .. > -> string
    
val name_of_box_T_lemma: <get_name : string; .. > -> string
  
val name_of_diamond_T_lemma: <get_name : string; .. > -> string
  
val name_of_box_4_lemma: <get_name : string; .. > -> string

val name_of_diamond_4_lemma: <get_name : string; .. > -> string

val name_of_box_linear_cons_lemma: <get_name : string; .. > -> string

val name_of_box_linear_append_lemma: <get_name : string; .. > -> string

val name_of_inv_inherit_lemma : <get_name : string; .. > -> string 

val name_of_box_inv_lemma: <get_name : string; .. > -> string

val name_of_diamond_inv_lemma: <get_name : string; .. > -> string

val name_of_box_greatest_inv_lemma: <get_name : string; .. > -> string

val name_of_box_inherit_lemma : <get_name : string; .. > -> string 

(*******************************************************************
 *
 * morphisms
 *)

val name_of_full_morphism_pred : <get_name : string; .. > -> string

val name_of_full_morphism_struct_pred : <get_name : string; .. > -> string

val name_of_public_morphism_pred : <get_name : string; .. > -> string

val name_of_morphism_bisim_lemma : <get_name : string; .. > -> string

val name_of_method_morphism_lemma_name : string -> string

val name_of_method_morphism_lemma : <get_name : string; .. > -> string

val name_of_coreduce_struct_morphism_lemma : <get_name : string; .. > -> string

val name_of_coreduce_morphism_lemma : <get_name : string; .. > -> string

val name_of_finality_existence : <get_name : string; .. > -> string

val name_of_class_coreduce : <get_name : string; .. > -> string

val name_of_class_struct_coreduce : <get_name : string; .. > -> string

val name_of_struct_coreduce_is_morph_lemma : <get_name : string; .. > -> string

val name_of_struct_coreduce_is_unique_lemma : <get_name : string; .. > -> string

    (* reduce is hardcoded in method inv_list_proof in the invariant theory *)
val name_of_adt_reduce : <get_name : string; .. > -> string

val name_of_finality_uniqueness : <get_name : string; .. > -> string

val name_of_finality : <get_name : string; .. > -> string

val name_of_finality_bisim_eq_lemma : <get_name : string; .. > -> string

(*******************************************************************
 *
 * file names
 *)

val ccsl_class_file_name : <get_name : string; .. > -> string

val ccsl_class_theorem_file_name : <get_name : string; .. > -> string

val ccsl_adt_file_name : <get_name : string; .. > -> string

val ccsl_sig_file_name : <get_name : string; .. > -> string

val name_of_pvs_ccsl_lib : string

val name_of_fixedpoints : string

val isar_theory_name :
  <get_name : string;
   belongs_to_prelude : bool;
   .. > -> string




(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)

