(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 1.10.97 by Hendrik
 *
 * Time-stamp: <Friday 2 July 10 10:59:14 tews@blau.inf.tu-dresden.de>
 *
 * make a wrapper around the Format module for reentrance support 
 *
 * $Id: formatter.ml,v 1.7 2010-07-02 10:55:56 tews Exp $
 *
 *)

(******************************************************************
 *
 * standard formatter functions from standart Format lib
 *)

let std_formatter = ref (Format.make_formatter (output stdout) 
		       (fun () -> flush stdout));;

let open_hbox x = Format.pp_open_hbox !std_formatter x
and open_vbox x = Format.pp_open_vbox !std_formatter x
and open_hvbox x = Format.pp_open_hvbox !std_formatter x
and open_hovbox x = Format.pp_open_hovbox !std_formatter x
and open_box x = Format.pp_open_box !std_formatter x
and close_box x = Format.pp_close_box !std_formatter x
and print_as x = Format.pp_print_as !std_formatter x
and print_string x = Format.pp_print_string !std_formatter x
and print_int x = Format.pp_print_int !std_formatter x
and print_float x = Format.pp_print_float !std_formatter x
and print_char x = Format.pp_print_char !std_formatter x
and print_bool x = Format.pp_print_bool !std_formatter x
and print_break x = Format.pp_print_break !std_formatter x
and print_cut x = Format.pp_print_cut !std_formatter x
and print_space x = Format.pp_print_space !std_formatter x
and force_newline x = Format.pp_force_newline !std_formatter x
and print_flush x = Format.pp_print_flush !std_formatter x
and print_newline x = Format.pp_print_newline !std_formatter x
and print_if_newline x = Format.pp_print_if_newline !std_formatter x
and open_tbox x = Format.pp_open_tbox !std_formatter x
and close_tbox x = Format.pp_close_tbox !std_formatter x
and print_tbreak x = Format.pp_print_tbreak !std_formatter x
and set_tab x = Format.pp_set_tab !std_formatter x
and print_tab x = Format.pp_print_tab !std_formatter x
and set_margin x = Format.pp_set_margin !std_formatter x
and get_margin x = Format.pp_get_margin !std_formatter x
and set_max_indent x = Format.pp_set_max_indent !std_formatter x
and get_max_indent x = Format.pp_get_max_indent !std_formatter x
and set_max_boxes x = Format.pp_set_max_boxes !std_formatter x
and get_max_boxes x = Format.pp_get_max_boxes !std_formatter x
and over_max_boxes x = Format.pp_over_max_boxes !std_formatter x
and set_ellipsis_text x = Format.pp_set_ellipsis_text !std_formatter x
and get_ellipsis_text x = Format.pp_get_ellipsis_text !std_formatter x
and set_formatter_out_channel x =
    Format.pp_set_formatter_out_channel !std_formatter x
and set_formatter_output_functions x =
    Format.pp_set_formatter_output_functions !std_formatter x
and get_formatter_output_functions x =
    Format.pp_get_formatter_output_functions !std_formatter x

(* provide all arguments here, because in 3.04 they forgot to
 * erase all the labels
 *)
and set_all_formatter_output_functions out flush newline spaces =
  Format.pp_set_all_formatter_output_functions !std_formatter 
    out flush newline spaces

and get_all_formatter_output_functions x = 
  Format.pp_get_all_formatter_output_functions !std_formatter x;;


(******************************************************************
 *
 * reentrance support
 *
 * this implements a stack of formatters, 
 * after push the obove functions use a *new* formatter
 *     the same output and flush functions
 * after corresponding pop previous formatting can be continued
 *)


let stack = (Stack.create () : Format.formatter Stack.t)

let push_formatter formatter =
  Stack.push (!std_formatter) stack;
  std_formatter := formatter

let pop_formatter () =
  begin
    print_flush();
    std_formatter := Stack.pop stack
  end;;


let stringwrapper f x =
  let buf = Buffer.create 1000 in
    push_formatter (Format.formatter_of_buffer buf);
    set_max_boxes max_int;
    f x;
    pop_formatter ();
    Buffer.contents buf
;;

(******************************************************************
 *
 * Initialization section
 *)

		       (* we need  deep nesting boxes for pretty printing *)
(set_max_boxes max_int);;

(******************************************************************
 *
 * Exit Code
 *)
    (* raise an exception, 
     * if there is still a formatter on the stack on exit 
     *)
exception Formatter_stack

let exit_function () =
  begin
    print_flush();
    if Stack.length stack <> 0 then
      raise Formatter_stack
  end

let _ = at_exit exit_function;;



(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)

