(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 26.1.99 by Hendrik
 *
 * Time-stamp: <Wednesday 8 May 02 11:41:09 tews@ithif51>
 *
 * Utility functions and variables used in _all_ parsers
 *
 * $Id: parser_util.mli,v 1.6 2002-05-22 13:42:46 tews Exp $
 *
 *)

open Top_variant_types;;

(* some state Variables for the parser *)

    (* current input file *)
val current_file : string ref

    (* current line number *)
val line : int ref

    (* absolute position of the start of the current line *)
val line_start : int ref


    (* adopt state vars after a newline parsed *)
val newline : int -> unit

    (* the state of this module:
     * line number, position of line start, file name
     *)
type state_type = (int * int * string)

    (* get the complete parser_util state *)
val get_state : unit -> state_type

    (* set the complete parser_util state *)
val set_state : state_type -> unit

    (* reset the line number to one again for a new file *)
val reset_line : string -> unit


    (* build a token for the current line, if there is no 
     * token available in the context 
     *)
val emergency_token : unit -> token_type


(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)

