(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * * Created 1.10.97 by Hendrik
 *
 * Time-stamp: <Wednesday 30 June 10 11:24:35 tews@blau.inf.tu-dresden.de>
 *
 * Utility functions for variant types
 *
 * $Id: top_variant_types_util.ml,v 1.25 2010-06-30 09:38:02 tews Exp $
 *
 *)


open Top_variant_types


(***********************************************************************
 ***********************************************************************
 *
 * Formloc utilities
 *
 *)

let is_form_loc = function
  | FormLoc _ -> true
  | _ -> false

let is_expr_loc = function
  | ExprLoc _ -> true
  | _ -> false


(*******************************************************************
 *******************************************************************
 *
 * Resolution utility
 * extended for ancestor containers
 * it is not clear to me, if delivering the class is really the 
 * intention of this function, but for the moment ...
 *)


let resolution_of = function
  | Resolved r -> r
  | Unresolved _ ->
      assert false


let ancestor_resolution_of = function
  | Resolved_renaming (_, _, _, icl,_) -> icl
  | Unresolved_renaming _ ->
	 assert false


(***********************************************************************
 ***********************************************************************
 *
 * dump a top_symbol
 *
 *)

let dump_symbol_brief (* : top_symbol_type -> string *) = function
  | CCSL_GroundTypeSymb id -> "Groundtype " ^ id.id_token.token_name
  | TypevarSymb id -> "Typevar " ^ id.id_token.token_name
  | VarSymb id -> "Var " ^ id.id_token.token_name
  | MemberSymb m -> "Member " ^ m#get_name
					   (* a ccsl class *)
  | ClassSymb cl -> "Class " ^ cl#get_name
					(* an instanciated ccsl class *)
  | InstClassSymb cl -> "IClass " ^ cl#get_name
					(* a ccsl adt *)
  | AdtSymb adt -> "Adt " ^ adt#get_name
					(* an instanciated ccsl adt *)
  | InstAdtSymb adt -> "IAdt " ^ adt#get_name
					(* a ground signature *)
  | SigSymb si -> "Sig " ^ si#get_name




(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)
