(* 
 * Formalized Cut Elimination in Coalgebraic Logics
 * 
 * Copyright (C) 2013 - 2013 Hendrik Tews
 * 
 * This file is part of my formalization of "Cut Elimination in 
 * Coalgebraic Logics" by Dirk Pattinson and Lutz Schroeder.
 * 
 * The formalization is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * The formalization is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the parent
 * directories for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with the formalization in the file COPYING. 
 * If not, see <http://www.gnu.org/licenses/>.
 * 
 * $Id: dsets.v,v 1.17 2013/04/10 11:17:14 tews Exp $
 *)

(** ** Basic definition for decidable sets

      A decidable set is one where one can decide member ship. I.E.,
      there must be a function computing the member ship and decidable
      sets are formalized as [_ -> bool].
 *)

Require Export misc.


Section Sets.

  Variable A : Type.

  Definition dset : Type := A -> bool.

  Definition dunion(P Q : dset) : dset := fun(a : A) => orb (P a) (Q a).

End Sets.

Implicit Arguments dunion [A].
