(* 
 * Formalized Cut Elimination in Coalgebraic Logics
 * 
 * Copyright (C) 2013 - 2013 Hendrik Tews
 * 
 * This file is part of my formalization of "Cut Elimination in 
 * Coalgebraic Logics" by Dirk Pattinson and Lutz Schroeder.
 * 
 * The formalization is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * The formalization is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the parent
 * directories for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with the formalization in the file COPYING. 
 * If not, see <http://www.gnu.org/licenses/>.
 * 
 * $Id: mixed_cut.v,v 1.11 2013/04/10 11:17:15 tews Exp $
 *)

(** ** Cut elimination case b, part of 5.6.3

      This modules contains case b) of the cut elimination proof for
      the induction step in 5.6.3. Case b) concerns cuts between a
      one-step rule and a propositional rule.
*)

Require Export propositional_properties.


Section Mixed_cut.

  Variable V : Type.
  Variable L : modal_operators.

  Lemma mixed_cut_ax :
    forall(rules : set (sequent_rule V L))(n : nat)(ssn_pos : 0 < 2 + n)
          (f : lambda_formula V L)(r q : sequent V L),
      not (neg_form_maybe prop_form f) ->
      simple_tautology (f :: q) ->
      rank_sequent (2 + n) (f :: q) ->
      rank_sequent (2 + n) r ->
        provable (G_n_set V L (2 + n))
          (provable_subst_n_conclusions rules (2 + n) ssn_pos) 
          (q ++ r).
  Proof.
    intros rules n ssn_pos f r q H H0 H1 H2.
    apply simple_tautology_cons_destruct in H0.
    decompose [ex and or] H0; clear H0.
        apply provable_with_rule with (assum := []).
          split.
            left.
            split.
              trivial.
            simpl.
            apply simple_tautology_append_right.
            trivial.
          split.
            apply every_nth_empty.
          simpl.
          apply rank_sequent_append.
            apply rank_sequent_tail in H1.
            trivial.
          trivial.
        apply every_nth_empty.
      exfalso.
      clear - H H5.
      destruct f; contradiction.
    subst f.
    simpl in H.
    contradiction.
  Qed.


  (* one-step rule left for  f :: q *)
  Lemma mixed_cut_left_osr :
    forall(rules : set (sequent_rule V L))(n m sd : nat)(ssn_pos : 0 < 2 + n)
          (f : lambda_formula V L)(r q : sequent V L)
          (negf_rule : sequent_rule V L)
          (H : G_n_set V L (2 + n) negf_rule)
          (negf_sub : 
             dep_list (sequent V L)
                      (proof (G_n_set V L (2 + n))
                          (provable_subst_n_conclusions rules (2 + n) ssn_pos))
                      (assumptions negf_rule)),
      one_step_rule_set rules ->
      (forall(f : lambda_formula V L)(r q : sequent V L),
         provable (G_n_set V L (2 + n)) 
                  (provable_subst_n_conclusions rules (2 + n) ssn_pos)
                  (f :: q) ->
         provable (G_n_set V L (2 + n))
                  (provable_subst_n_conclusions rules (2 + n) ssn_pos)
                  (lf_neg f :: r) ->
         formula_measure f < m ->
           provable (G_n_set V L (2 + n))
                    (provable_subst_n_conclusions rules (2 + n) ssn_pos) 
                    (q ++ r)) ->
      (forall(f : lambda_formula V L)(r q : sequent V L)
             (p_fq : proof (G_n_set V L (2 + n))
                           (provable_subst_n_conclusions rules (2 + n) ssn_pos)
                           (f :: q))
             (p_nfr : proof (G_n_set V L (2 + n))
                            (provable_subst_n_conclusions rules (2 + n) ssn_pos)
                            (lf_neg f :: r)),
         proof_depth p_fq + proof_depth p_nfr <= sd ->
         formula_measure f < S m ->
           provable (G_n_set V L (2 + n))
                    (provable_subst_n_conclusions rules (2 + n) ssn_pos) 
                    (q ++ r)) ->
      formula_measure f < S m ->
      1 + proof_depth (rule (G_n_set V L (2 + n))
                            (provable_subst_n_conclusions rules (2 + n) ssn_pos)
                            negf_rule H negf_sub)
         <= S sd ->
      provable_subst_n_conclusions rules (2 + n) ssn_pos (f :: q) ->
      conclusion negf_rule = lf_neg f :: r ->
        provable (G_n_set V L (2 + n))
          (provable_subst_n_conclusions rules (2 + n) ssn_pos) 
          (q ++ r).
  Proof.
    intros rules n m sd ssn_pos f r q negf_rule H negf_sub H0 H1 H2 H3 H4 H5 H6.
    assert(H7 := H5).
    unfold provable_subst_n_conclusions, rank_weaken_subst_rule in H7.
    decompose [ex and] H7; clear H7.
    rename x into subst_rule, x0 into osr, x1 into sigma_l, x2 into delta_l.
    rewrite <- H13 in *.
    assert (H16 := list_reorder_single_append _ _ _ _ H14).
    destruct H16.
      destruct H7 as [osr_concl].
      assert (top_modal_form f).
        clear H2 H3 H5.
        eapply top_modal_sequent_head.
        eapply top_modal_sequent_list_reorder.
          eexact H7.
        apply one_step_rule_subst_top_modal_conclusion.
        auto.
      simpl in H8.
      eapply rank_sequent_osr_subst_conclusion in H14; eauto.
      clear subst_rule osr sigma_l delta_l 
            H9 H8 H11 H12 H13 H15 osr_concl H7.
      decompose [or] (decompose_G_n_set_coarsly _ _ H).
        rewrite H6 in *; clear H6.
        eapply provable_G_n_hyp_list_reorder.
            apply multiset_provable_subst_n_conclusions.
          apply list_reorder_append_swap.
        apply mixed_cut_ax with (f := lf_neg f).
              simpl.
              apply top_modal_not_prop.
              trivial.
            apply H7.
          apply H7.
        eapply rank_sequent_tail in H14.
        trivial.
      decompose [ex and] H7; clear H7.
      clear H8.
      rename x into negfb_rule, x0 into sl, x1 into sr.
      apply le_S_n in H4.
      destruct sd.
        eapply proof_depth_0.
        eexact H4.
      apply proof_depth_rule_le_inv in H4.
      assert (H7 := H6).
      rewrite H11 in H9, H7.
      unfold rule_add_context in H9, H7.
      simpl in H9, H7.
      unfold add_context in H9, H7.
      destruct sl.
        clear H9.
        rewrite <- H15 in H7.
        simpl in H7.
        inversion H7; clear H7.
        subst x2 sr.
        decompose [ex or] H12; clear H12.
            rename x into f1, x0 into f2.
            exfalso.
            subst negfb_rule.
            clear - H15.
            unfold bare_and_rule in *.
            simpl in *.
            discriminate.
          rename x into f1, x0 into f2.
          exfalso.
          subst negfb_rule.
          clear - H10 H15.
          unfold bare_neg_and_rule in *.
          simpl in *.
          inversion H15; clear H15.
          subst f.
          contradiction.
        rename x into f'.
        clear H2.
        subst negfb_rule.
        unfold bare_neg_neg_rule in H15.
        simpl in H15.
        inversion H15; clear H15.
        subst f.
        eapply G_n_cut_elim_head_neg_neg_inside; eauto.
              apply multiset_provable_subst_n_conclusions.
            apply head_inversion_provable_subst_n_conclusion.
            trivial.
          exists (assume _ _ _ H5).
          trivial.
        rewrite <- H6.
        exists (rule _ _ _ H negf_sub).
        trivial.
      clear H H1 H6 H10 x2 H15.
      subst negf_rule.
      unfold rule_add_context in *.
      simpl in *.
      inversion H7; clear H7.
      subst l.
      apply provable_G_n_hyp_list_reorder 
                   with (s1 := sl ++ conclusion negfb_rule ++ sr ++ q).
          apply multiset_provable_subst_n_conclusions.
        clear.
        apply list_reorder_symm.
        rewrite (app_assoc sl).
        eapply list_reorder_trans.
          apply list_reorder_append_3_middle.
        rewrite (app_assoc sl).
        apply list_reorder_append_left.
        apply list_reorder_append_swap.
      apply provable_with_rule with 
             (s := add_context sl (sr ++ q) (conclusion negfb_rule))
             (assum := map (add_context sl (sr ++ q))
                           (assumptions negfb_rule)).
        apply sequent_other_context_G_n_set 
                            with (sl1 := lf_neg f :: sl)(sr1 := sr); eauto.
          clear. 
          intros H.
          apply rank_sequent_tail in H.
          trivial.
        clear - H14.
        intros H.
        apply rank_sequent_tail in H14.
        apply rank_sequent_append; trivial.
      apply every_nth_exists_inv in H4.
      assert (provable (G_n_set V L (2 + n))
                       (provable_subst_n_conclusions rules (2 + n) ssn_pos)
                       (f :: q)).
        exists (assume _ _ _ H5).
        trivial.
      assert (forall(r : sequent V L),
                provable_at_depth (G_n_set V L (2 + n)) 
                     (provable_subst_n_conclusions rules (2 + n) ssn_pos)
                     sd (lf_neg f :: r) ->
                  provable (G_n_set V L (2 + n)) 
                    (provable_subst_n_conclusions rules (2 + n) ssn_pos)
                    (r ++ q)).
        clear - H2 H3 H5.
        intros r H.
        eapply provable_G_n_hyp_list_reorder.
            apply multiset_provable_subst_n_conclusions.
          apply list_reorder_append_swap.
        destruct H as [p_nfr].
        apply H2 with (p_fq := assume _ _ _ H5)(p_nfr := p_nfr); trivial.
        simpl.
        apply le_n_S.
        trivial.
      clear H2.
      decompose [ex or] H12; clear H12.
          eapply G_n_cut_elim_head_and_outside; eauto.
        eapply G_n_cut_elim_head_neg_and_outside; eauto.
      eapply G_n_cut_elim_head_neg_neg_outside; eauto.
    clear negf_sub H1 H2 H3 H4.
    assert (provable_subst_n_conclusions rules (2 + n) ssn_pos (q ++ r)).
      destruct H7 as [delta_l_tl].
      eapply cut_elimination_osr_context; eauto.
        rewrite <- H12.
        trivial.
      apply rank_sequent_tail with (f := lf_neg f).
      rewrite <- H6.
      apply H.
    exists (assume _ _ _ H1).
    trivial.
  Qed.

  (* one-step rule right for  (lf_neg f) :: r *)
  Lemma mixed_cut_right_osr :
    forall(rules : set (sequent_rule V L))(n m sd : nat)(ssn_pos : 0 < 2 + n)
          (f : lambda_formula V L)(r q : sequent V L)
          (f_rule : sequent_rule V L)
          (H : G_n_set V L (2 + n) f_rule)
          (f_sub : 
             dep_list (sequent V L)
                      (proof (G_n_set V L (2 + n))
                          (provable_subst_n_conclusions rules (2 + n) ssn_pos))
                      (assumptions f_rule)),
      one_step_rule_set rules ->
      (forall(f : lambda_formula V L)(r q : sequent V L)
             (p_fq : proof (G_n_set V L (2 + n))
                           (provable_subst_n_conclusions rules (2 + n) ssn_pos)
                           (f :: q))
             (p_nfr : proof (G_n_set V L (2 + n))
                            (provable_subst_n_conclusions rules (2 + n) ssn_pos)
                            (lf_neg f :: r)),
         proof_depth p_fq + proof_depth p_nfr <= sd ->
         formula_measure f < S m ->
           provable (G_n_set V L (2 + n))
                    (provable_subst_n_conclusions rules (2 + n) ssn_pos) 
                    (q ++ r)) ->
      formula_measure f < S m ->
      proof_depth (rule (G_n_set V L (2 + n))
                        (provable_subst_n_conclusions rules (2 + n) ssn_pos)
                         f_rule H f_sub)
        + 1 <= S sd ->
      conclusion f_rule = f :: q ->
      provable_subst_n_conclusions rules (2 + n) ssn_pos ((lf_neg f) :: r) ->
        provable (G_n_set V L (2 + n))
          (provable_subst_n_conclusions rules (2 + n) ssn_pos)
          (q ++ r).
  Proof.
    intros rules n m sd ssn_pos f r q f_rule H f_sub H0 H1 H2 H3 H4 H5.
    assert (H6 := H5).
    unfold provable_subst_n_conclusions, rank_weaken_subst_rule in H6.
    decompose [ex and] H6; clear H6.
    rename x into subst_rule, x0 into osr, x1 into sigma_r, x2 into delta_r.
    rewrite <- H12 in *.
    assert (H15 := list_reorder_single_append _ _ _ _ H13).
    destruct H15.
      destruct H6 as [osr_concl].
      assert (top_modal_form f).
        apply top_modal_form_lf_neg.
        eapply top_modal_sequent_head.
        eapply top_modal_sequent_list_reorder.
          eexact H6.
        apply one_step_rule_subst_top_modal_conclusion.
        auto.
      simpl in H7.
      eapply rank_sequent_osr_subst_conclusion in H13; eauto.
      clear subst_rule osr sigma_r delta_r H8 H7 H10 H11 H12 H14 osr_concl H6.
      decompose [or] (decompose_G_n_set_coarsly _ _ H).
        rewrite H4 in *.
        apply mixed_cut_ax with (f := f).
              apply top_modal_not_neg_prop.
              trivial.
            apply H6.
          apply H6.
        eapply rank_sequent_tail in H13.
        trivial.
      decompose [ex and] H6; clear H6.
      clear H7.
      rename x into fb_rule, x0 into sl, x1 into sr.
      rewrite plus_comm in H3.
      apply le_S_n in H3.
      destruct sd.
        eapply proof_depth_0.
        eexact H3.
      apply proof_depth_rule_le_inv in H3.
      clear H.
      subst f_rule.
      unfold rule_add_context in *.
      simpl in *.
      unfold add_context in H8, H4.
      destruct sl.
        clear H8.
        rewrite <- H14 in H4.
        simpl in H4.
        inversion H4; clear H4.
        subst x2 sr.
        decompose [ex or] H11; clear H11.
            rename x into f1, x0 into f2.
            exfalso.
            subst fb_rule.
            clear - H9 H14.
            unfold bare_and_rule in *.
            simpl in *.
            inversion H14; clear H14.
            subst f.
            contradiction.
          rename x into f1, x0 into f2.
          exfalso.
          subst fb_rule.
          clear - H9 H14.
          unfold bare_neg_and_rule in *.
          simpl in *.
          inversion H14; clear H14.
          subst f.
          contradiction.
        rename x into f'.
        exfalso.
        subst fb_rule.
        clear - H9 H14.
        unfold bare_neg_neg_rule in *.
        simpl in *.
        inversion H14; clear H14.
        subst f.
        contradiction.
      clear H9 x2 H14.
      simpl in H8, H4.
      inversion H4; clear H4.
      subst l.
      repeat rewrite app_assoc_reverse.
      apply provable_with_rule with 
             (s := add_context sl (sr ++ r) (conclusion fb_rule))
             (assum := map (add_context sl (sr ++ r)) (assumptions fb_rule)).
        apply sequent_other_context_G_n_set 
                            with (sl1 := f :: sl)(sr1 := sr); auto.
          clear. 
          intros H.
          apply rank_sequent_tail in H.
          trivial.
        clear - H13.
        intros H.
        apply rank_sequent_append.
          trivial.
        apply rank_sequent_tail in H13.
        trivial.
      apply every_nth_exists_inv in H3.
      assert (provable (G_n_set V L (2 + n))
                       (provable_subst_n_conclusions rules (2 + n) ssn_pos)
                       (lf_neg f :: r)).
        exists (assume _ _ _ H5).
        trivial.
      assert (forall(q : sequent V L),
                provable_at_depth (G_n_set V L (2 + n)) 
                     (provable_subst_n_conclusions rules (2 + n) ssn_pos)
                     sd (f :: q) ->
                  provable (G_n_set V L (2 + n)) 
                    (provable_subst_n_conclusions rules (2 + n) ssn_pos)
                    (q ++ r)).
        clear - H1 H2 H5.
        intros q H0.
        destruct H0 as [p_fq].
        apply H1 with (p_fq := p_fq)(p_nfr := assume _ _ _ H5); trivial.
        rewrite proof_depth_assume.
        rewrite plus_comm.
        apply le_n_S.
        trivial.
      clear H1.
      decompose [ex or] H11; clear H11.
          eapply G_n_cut_elim_head_and_outside; eauto.
        eapply G_n_cut_elim_head_neg_and_outside; eauto.
      eapply G_n_cut_elim_head_neg_neg_outside; eauto.
    clear f_sub H1 H2 H3.
    assert (provable_subst_n_conclusions rules (2 + n) ssn_pos (q ++ r)).
      destruct H6 as [delta_r_tl].
      apply multiset_provable_subst_n_conclusions with (s := r ++ q).
        eapply cut_elimination_osr_context; eauto.
          rewrite <- H11.
          trivial.
        apply rank_sequent_tail with (f := f).
        rewrite <- H4.
        apply H.
      apply list_reorder_append_swap.
    exists (assume _ _ _ H1).
    trivial.
  Qed.

End Mixed_cut.
