(* 
 * Formalized Cut Elimination in Coalgebraic Logics
 * 
 * Copyright (C) 2013 - 2013 Hendrik Tews
 * 
 * This file is part of my formalization of "Cut Elimination in 
 * Coalgebraic Logics" by Dirk Pattinson and Lutz Schroeder.
 * 
 * The formalization is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * The formalization is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the parent
 * directories for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with the formalization in the file COPYING. 
 * If not, see <http://www.gnu.org/licenses/>.
 * 
 * $Id: some_nth.v,v 1.3 2013/04/10 11:17:17 tews Exp $
 *)

(** ** some_nth predicate for lists *)

Require Export lists.

Section Some_nth.

  Variable A : Type.

  Variable P : A -> Prop.


  Definition some_nth(l : list A) : Prop :=
    exists(n : nat)(n_less : n < length l), P (nth l n n_less).


  Lemma some_nth_some :
    forall(l : list A)(n : nat)(n_less : n < length l),
      P (nth l n n_less) -> some_nth l.
  Proof.
    intros l n n_less H.
    exists n, n_less.
    trivial.
  Qed.

  Lemma some_nth_singleton :
    forall(a : A), P a <-> some_nth [a].
  Proof.
    intros a.
    split.
      intros H.
      exists 0, (lt_0_Sn 0).
      trivial.
    intros H.
    destruct H as [n].
    destruct H as [n_less].
    destruct n.
      trivial.
    clear H.
    simpl in *.
    omega.
  Qed.

End Some_nth.

Implicit Arguments some_nth [A].
