// tokens.h
// token codes for occ2

#ifndef TOKENS_H
#define TOKENS_H

enum Token {
  TOK_EOF,
  TOK_NAME,
  TOK_TYPE_NAME,
  TOK_VARIABLE_NAME,
  TOK_INT_LITERAL,
  TOK_FLOAT_LITERAL,
  TOK_STRING_LITERAL,
  TOK_CHAR_LITERAL,
  TOK_UDEF_QUAL,
  TOK_ASM,                       // "asm"
  TOK_AUTO,                      // "auto"
  TOK_BREAK,                     // "break"
  TOK_BOOL,                      // "bool"
  TOK_CASE,                      // "case"
  TOK_CATCH,                     // "catch"
  TOK_CDECL,                     // "cdecl"
  TOK_CHAR,                      // "char"
  TOK_CLASS,                     // "class"
  TOK_CONST,                     // "const"
  TOK_CONST_CAST,                // "const_cast"
  TOK_CONTINUE,                  // "continue"
  TOK_DEFAULT,                   // "default"
  TOK_DELETE,                    // "delete"
  TOK_DO,                        // "do"
  TOK_DOUBLE,                    // "double"
  TOK_DYNAMIC_CAST,              // "dynamic_cast"
  TOK_ELSE,                      // "else"
  TOK_ENUM,                      // "enum"
  TOK_EXPLICIT,                  // "explicit"
  TOK_EXPORT,                    // "export"
  TOK_EXTERN,                    // "extern"
  TOK_FALSE,                     // "false"
  TOK_FLOAT,                     // "float"
  TOK_FOR,                       // "for"
  TOK_FRIEND,                    // "friend"
  TOK_GOTO,                      // "goto"
  TOK_IF,                        // "if"
  TOK_INLINE,                    // "inline"
  TOK_INT,                       // "int"
  TOK_LONG,                      // "long"
  TOK_MUTABLE,                   // "mutable"
  TOK_NAMESPACE,                 // "namespace"
  TOK_NEW,                       // "new"
  TOK_OPERATOR,                  // "operator"
  TOK_PASCAL,                    // "pascal"
  TOK_PRIVATE,                   // "private"
  TOK_PROTECTED,                 // "protected"
  TOK_PUBLIC,                    // "public"
  TOK_REGISTER,                  // "register"
  TOK_REINTERPRET_CAST,          // "reinterpret_cast"
  TOK_RETURN,                    // "return"
  TOK_SHORT,                     // "short"
  TOK_SIGNED,                    // "signed"
  TOK_SIZEOF,                    // "sizeof"
  TOK_STATIC,                    // "static"
  TOK_STATIC_CAST,               // "static_cast"
  TOK_STRUCT,                    // "struct"
  TOK_SWITCH,                    // "switch"
  TOK_TEMPLATE,                  // "template"
  TOK_THIS,                      // "this"
  TOK_THROW,                     // "throw"
  TOK_TRUE,                      // "true"
  TOK_TRY,                       // "try"
  TOK_TYPEDEF,                   // "typedef"
  TOK_TYPEID,                    // "typeid"
  TOK_TYPENAME,                  // "typename"
  TOK_UNION,                     // "union"
  TOK_UNSIGNED,                  // "unsigned"
  TOK_USING,                     // "using"
  TOK_VIRTUAL,                   // "virtual"
  TOK_VOID,                      // "void"
  TOK_VOLATILE,                  // "volatile"
  TOK_WCHAR_T,                   // "wchar_t"
  TOK_WHILE,                     // "while"
  TOK_LPAREN,                    // "("
  TOK_RPAREN,                    // ")"
  TOK_LBRACKET,                  // "["
  TOK_RBRACKET,                  // "]"
  TOK_ARROW,                     // "->"
  TOK_COLONCOLON,                // "::"
  TOK_DOT,                       // "."
  TOK_BANG,                      // "!"
  TOK_TILDE,                     // "~"
  TOK_PLUS,                      // "+"
  TOK_MINUS,                     // "-"
  TOK_PLUSPLUS,                  // "++"
  TOK_MINUSMINUS,                // "--"
  TOK_AND,                       // "&"
  TOK_STAR,                      // "*"
  TOK_DOTSTAR,                   // ".*"
  TOK_ARROWSTAR,                 // "->*"
  TOK_SLASH,                     // "/"
  TOK_PERCENT,                   // "%"
  TOK_LEFTSHIFT,                 // "<<"
  TOK_RIGHTSHIFT,                // ">>"
  TOK_LESSTHAN,                  // "<"
  TOK_LESSEQ,                    // "<="
  TOK_GREATERTHAN,               // ">"
  TOK_GREATEREQ,                 // ">="
  TOK_EQUALEQUAL,                // "=="
  TOK_NOTEQUAL,                  // "!="
  TOK_XOR,                       // "^"
  TOK_OR,                        // "|"
  TOK_ANDAND,                    // "&&"
  TOK_OROR,                      // "||"
  TOK_QUESTION,                  // "?"
  TOK_COLON,                     // ":"
  TOK_EQUAL,                     // "="
  TOK_STAREQUAL,                 // "*="
  TOK_SLASHEQUAL,                // "/="
  TOK_PERCENTEQUAL,              // "%="
  TOK_PLUSEQUAL,                 // "+="
  TOK_MINUSEQUAL,                // "-="
  TOK_ANDEQUAL,                  // "&="
  TOK_XOREQUAL,                  // "^="
  TOK_OREQUAL,                   // "|="
  TOK_LEFTSHIFTEQUAL,            // "<<="
  TOK_RIGHTSHIFTEQUAL,           // ">>="
  TOK_COMMA,                     // ","
  TOK_ELLIPSIS,                  // "..."
  TOK_SEMICOLON,                 // ";"
  TOK_LBRACE,                    // "{"
  TOK_RBRACE,                    // "}"
  TOK___ATTRIBUTE__,             // "__attribute__"
  TOK___FUNCTION__,              // "__FUNCTION__"
  TOK___LABEL__,                 // "__label__"
  TOK___PRETTY_FUNCTION__,       // "__PRETTY_FUNCTION__"
  TOK___TYPEOF__,                // "__typeof__"
};

#endif // TOKENS_H
