(* (C) 1999-2004                                                 *)
(* Cuihtlauac Alvarado, France Telecon, Recherche & Developement *)
(* Jean-Franois Monin, Universit Joseph Fourier - VERIMAG      *)

(* ocamlc options: !-I `camlp4o -where`!*)

(* $Id: editor.ml,v 1.4 2007-04-06 20:58:17 tews Exp $ *)

let char_del = Char.chr 127
let char_soh =  Char.chr 1
let char_np = Char.chr 12

let sized_string_of_file f size =
  let buf = String.create size in
  let cin = open_in_bin f in
  let rec loop lus0 t0 =
    let n = input cin buf lus0 t0 in
    let lus = lus0 + n in let t = t0 - n in 
    if n > 0 && t > 0 then loop lus t else lus in
  let lus = loop 0 size in close_in cin;
  buf,lus

let make_strings f lg_file =
  let lg_with_nl = lg_file + 1 in
  let fs, l = sized_string_of_file f lg_with_nl in
  fs.[l - 1] <- '\n';
  (fs, l)

module Line : sig
  val lookup : string * int -> unit
  val of_pos : int -> int * int
  val print : unit -> unit
end = struct
  module LN = Line_number
  let pos_set = LN.create ()
  let lookup (file, len) =
    let add n = LN.add pos_set n in
    let rec look_nl n0 = 
      if n0 < len then begin
        let n = String.index_from file n0 '\n' in
        add n; look_nl (n + 1)
      end else () in
    try look_nl 0 with Not_found -> ()
  let of_pos p =
    let x = LN.find pos_set p in
    LN.first x, LN.num x
  let print () = LN.print pos_set
end

let process_file ini header get_size_ml format _ =
  let in_file = !Pcaml.input_file in
  let name = Filename.basename in_file in
  let modulename = String.capitalize (Filename.chop_extension name) in
  (* let sini, nini = Printf.sprintf "%s\t%s\t1;\n" modulename in_file, 0 in *)
  let sini, nini = ini modulename in_file in
  let file_len = get_size_ml () in
  let fsl = make_strings in_file file_len in
  Line.lookup fsl;
  let lef, nef = format in_file fsl in
  (* let out_chan = open_out (Sys.getenv Conf.tmp_tags) in *)
  let out_chan = begin match !Pcaml.output_file with 
    | None -> stdout
    | Some out_file -> open_out out_file
  end in
  header out_chan in_file nini nef;
  List.iter (output_string out_chan) (sini :: lef);
  flush out_chan;
  close_out out_chan

