(* (C) 1999-2004                                                 *)
(* Cuihtlauac Alvarado, France Telecon, Recherche & Developement *)
(* Jean-Franois Monin, Universit Joseph Fourier - VERIMAG      *)

(* $Id: emacs.ml,v 1.7 2007-08-23 09:25:53 tews Exp $ *)

(* Store entries before writing them down. *)
let lifo : (string * int * int) list ref = ref []

let set_size_ml, get_size_ml =
  let c = ref 0 in
  let set n = c := n in
  let get () = !c
  in set, get

let add etag (loc, last) =
  lifo := (etag, loc, last) :: !lifo; set_size_ml last

let line sbeg tagname n ibeg =
  let etag =
    Printf.sprintf "%s%c%s%c%d,%d\n" 
      sbeg 
      Editor.char_del 
      tagname 
      Editor.char_soh 
      n 
      ibeg 
  in
  etag, (String.length etag)

(* TODO: use KMP *)
let rec search_forward_loop pat str pos =
  if String.sub str pos (String.length pat) = pat then pos
  else search_forward_loop pat str (pos + 1)

let search_forward pat str pos =
  try
    search_forward_loop pat str pos
  with
    | Invalid_argument "String.sub" ->	(* pat does not occur in str *)
	pos

let format filename (fs, l) =
  let rec loop lcur scur = function
    | [] -> lcur, scur
    | (entry, pos, last) :: rest ->
        let line_beg, _ = Editor.Line.of_pos pos in
        (* let entry_pos = Str.search_forward (Str.regexp entry) fs line_beg in 
	*)
        let entry_pos = search_forward entry fs line_beg in
        let line_beg, line_num = Editor.Line.of_pos entry_pos in
        let len = entry_pos - line_beg + String.length entry in
	let line_start = 
	  try
	    String.sub fs line_beg len
	  with
	    | Invalid_argument "String.sub" -> 
		(* Treat the case of camlp4 generated identifiers:
		 * They do not occur in the file, 
		 * so pos = line_beg (see search_forward above).
		 * Further they might be longer than the current line
		 * or even longer than the reminder of the file
		 *)
		String.sub fs line_beg ((String.length fs) - line_beg)
	in
	  (* Now cut out everything to the end of the line *)
	let line_start =
	  try
	    String.sub line_start 0 (String.index line_start '\n')
	  with
	    | Not_found -> 		(* no newline in line_start *)
		line_start
	in
        let fl, n = 
          line line_start entry line_num line_beg 
	in
          loop (fl :: lcur) (n + scur) rest
  in 
    loop [] 0 !lifo

let header chan src nini nef = 
  Printf.fprintf chan "%c\n%s,%d\n" Editor.char_np src (nini + nef)

let ini modulename in_file =
  line "" modulename 1 0

let _ = at_exit (Editor.process_file ini header get_size_ml format) 

