(* (C) 1999-2004                                                 *)
(* Cuihtlauac Alvarado, France Telecon, Recherche & Developement *)
(* Jean-Franois Monin, Universit Joseph Fourier - VERIMAG      *)

(* $Id: line_number.ml,v 1.2 2005-10-13 12:57:06 tews Exp $ *)

module Ord_int =
  struct
    type t = int
    let default = 0
    let compare x y = x - y
  end

module Inh_int =
  struct
    type t = int
    let default = 0
  end

(* module S = Splay.Make(Ord_int) (Inh_int) *)

module Spl = Splay.Make(Ord_int) (Inh_int)

type t = { tree : Spl.t; mutable cur_line_num : int }
type elt = int * int
let print t =
  print_string "spl = ";
  Spl.print print_int print_int t.tree;
  Printf.printf "cur_line_num = %d\n" t.cur_line_num;
  flush stdout
let create () =
  let t = { tree=Spl.create (); cur_line_num = 1 } in
  Spl.add t.tree 0 1; t
let add t n =
  let ln = t.cur_line_num + 1 in
  Spl.add t.tree (n+1) ln; t.cur_line_num <- ln
let find t n = Spl.floor t.tree n
let first (f,n) = f
let num (f,n) = n
