(* Otags reloaded
 * 
 * Hendrik Tews Copyright (C) 2010 - 2016
 * 
 * This file is part of "Otags reloaded".
 * 
 * "Otags reloaded" is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * "Otags reloaded" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the parent
 * directories for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with "Otags reloaded". If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * $Id: monitor_line_directive.mli,v 1.3 2016/01/14 20:17:46 tews Exp $
 * 
 * filter and store line directives
 * 
 *)


(** Record for storing line directives for correcting character
    offsets in locations.
 *)
type line_directive_record = {
  ld_file : string;	    (** the file name of the line directive *)
  ld_line : int;	    (** the line number of the line directive *)
  ld_parse_offset : int;    (** the character offset of the end of the line
                                directive in the parsed character stream *)
  mutable ld_file_offset : int;	(** cache for the character offset of line 
                                ld_line in file ld_file, -1 when invalid, 
                                written in Tranlate_location when needed. *)
}

(** list of all line directives after parsing completed. Should be reset
    after each parsed unit.
 *)
val parsed_line_directives : line_directive_record list ref

(** Last filename seen in a line directive for cppo, which emits 
    line directives without filenames. Not used outside of this module, 
    but should be reset together with parsed_line_directives.
 *)
val last_filename : string option ref

module Line_directive_monitor : 
  functor(Syn : Camlp4.Sig.Camlp4Syntax) -> Camlp4.Sig.Camlp4Syntax
