
let standard_syntax = ref true

let parse_impl = ref true

let ocaml_path = ref ""

let verbose = ref false

let dump_file = ref None

let arguments = Arg.align [
  ("-r", Arg.Clear standard_syntax,
   " parse revised syntax");
  ("-i", Arg.Clear parse_impl,
   " parse interface");
  ("-ocaml", Arg.Set_string ocaml_path,
   "path set the path to the ocaml bin-dir");
  ("-dump", Arg.String(fun f -> dump_file := Some f),
   "dump-file print ast from dump-file instead of parsing input");
  ("-v", Arg.Set verbose,
   " verbose");
]

let usage = "dump-camlp4"

let _ = Arg.parse arguments (fun _ -> assert false) usage
  
let camlp4_name = match !standard_syntax with
  | true -> "camlp4o"
  | false -> "camlp4r"

let camlp4_name = Filename.concat !ocaml_path camlp4_name

let mode_flag = match !parse_impl with
  | true -> "-impl"
  | false -> "-intf"

let parse_command = 
  camlp4_name ^ " " ^ mode_flag ^ " - -printer d > camlp4-dump"

let _ = 
  match !dump_file with
    | None ->
      if !verbose then
	Printf.eprintf "Run: %s\n%!" parse_command;
      ignore(Sys.command parse_command)
    | Some f ->
      if !verbose then
	Printf.eprintf "don't parse any input, use dump in %s\n%!" f


let ast_file = match !dump_file with
  | None -> "camlp4-dump"
  | Some f -> f


let input = 
  "#print_depth 1073741823;;
   #print_length 1073741823;;
   #load \"dynlink.cma\";; 
   #load \"camlp4lib.cma\";;
   open Camlp4.PreCast;;
   let loc_printer ff loc =
     Format.fprintf ff \"[%s: sl %d(%d) so %d el %d(%d) eo %d%s]\"
       (Loc.file_name loc)
       (Loc.start_line loc) (Loc.start_bol loc) (Loc.start_off loc)
       (Loc.stop_line loc) (Loc.stop_bol loc) (Loc.stop_off loc)
       (if Loc.is_ghost loc then \" GHOST\" else \" REAL\");;
   #install_printer loc_printer;;
   open Camlp4.PreCast.Ast;;
   let buf = String.create 14 in
   let ic = open_in \""
    ^ ast_file ^
   "\" in
   really_input ic buf 0 14;
   (input_value ic : Ast."
    ^
    (if !parse_impl then "str_item"
     else "sig_item")
    ^ ");;
"

let ocaml_command = 
  "echo '" ^ input ^ "' | " ^ (Filename.concat !ocaml_path "ocaml")
;;

if !verbose then
  Printf.eprintf "Run: %s\n%!" ocaml_command;
Sys.command ocaml_command


(*** Local Variables: ***)
(*** compile-command: "ocamlopt.opt dump-camlp4.ml -o dump-camlp4" ***)
(*** End: ***)
