(* Otags reloaded
 * 
 * Hendrik Tews Copyright (C) 2010
 * 
 * This file is part of "Otags reloaded".
 * 
 * "Otags reloaded" is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * "Otags reloaded" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the parent
 * directories for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with "Otags reloaded". If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * $Id: emacs.ml,v 1.4 2010-08-22 12:36:16 tews Exp $
 * 
 * write emacs tags files
 * 
 *)

open Types
open Misc

module Loc = Camlp4.PreCast.Loc


type emacs_tag_state = {
  tags_oc : out_channel;
  buf : Buffer.t;
  mutable file : string;
  mutable ic : in_channel;
}


let emacs_tag_line line tag line_number char =
  Printf.sprintf "%s\127%s\001%d,%d\n" line tag line_number char


let start_unit es file ic =
  let mod_name = module_name file in
  let module_tag = emacs_tag_line "" mod_name 1 0 in
  assert(Buffer.length es.buf = 0);
  Buffer.add_string es.buf module_tag;
  es.file <- file;
  es.ic <- ic    
  

let write_tag es loc tag = 
  (* 
   * Printf.eprintf "%s: def %s line %d: %s\n"
   *   (Loc.to_string loc)
   *   (cut_out source_ic (Loc.start_off loc) (Loc.stop_off loc))
   *   (Loc.start_bol loc)
   *   (cut_out source_ic (Loc.start_bol loc) (Loc.stop_off loc));
   *)
  Buffer.add_string es.buf 
    (emacs_tag_line
       (cut_out es.ic (Loc.start_bol loc) (Loc.stop_off loc))
       tag
       (Loc.start_line loc)
       (Loc.start_bol loc))


let finish_unit es () =
  Printf.fprintf es.tags_oc "\012\n%s,%d\n" 
    es.file
    (Buffer.length es.buf);
  Buffer.output_buffer es.tags_oc es.buf;
  Buffer.clear es.buf;
  es.ic <- stdin;
  ()
  

let finish_tagging _es () = ()

let init oc =
  let es = {
    tags_oc = oc;
    buf = Buffer.create 65535;
    file = "";
    ic = stdin;
  }
  in {
    start_unit = start_unit es;
    write_tag = write_tag es;
    finish_unit = finish_unit es;
    finish_tagging = finish_tagging es;
  }
