(* Otags reloaded
 * 
 * Hendrik Tews Copyright (C) 2010 - 2012
 * 
 * This file is part of "Otags reloaded".
 * 
 * "Otags reloaded" is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * "Otags reloaded" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the parent
 * directories for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with "Otags reloaded". If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * $Id: misc.ml,v 1.7 2012-01-14 21:31:39 tews Exp $
 * 
 * some misc functions
 * 
 *)

let the = function
  | Some x -> x
  | None -> assert false


(* return true if s2 is an initial substring of s1 *)
let starts_with s1 s2 =
  let s1_len = String.length s1 in
  let s2_len = String.length s2 in
  if s1_len >= s2_len then
    (String.sub s1 0 s2_len) = s2
  else false


let module_name file_name = 
  let base = Filename.basename file_name in
  let module_name =
    if Filename.check_suffix base ".ml"
    then Filename.chop_suffix base ".ml"
    else if Filename.check_suffix base ".mli"
    then Filename.chop_suffix base ".mli"
    else base
  in
  String.capitalize module_name


(* cut_out in_channel start end 
 * cuts the string from start - end out of in_channel
 *)
let cut_out inc start_pos end_pos =
  (* XXX work around out-of-file end positions in 3.11
   * this is fixed in 3.12
   *)
  let end_pos = min end_pos (in_channel_length inc) in
  let len = end_pos - start_pos in
  (* Printf.eprintf "CUTOUT %d %d %d\n%!" start_pos end_pos len; *)
  let buf = String.create len
  in
    seek_in inc start_pos;
    really_input inc buf 0 len;
    buf


let input_line_at ic pos =
  seek_in ic pos;
  input_line ic
